/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.common.connection;

import cn.jpush.api.common.connection.HttpProxy;
import cn.jpush.api.common.connection.IHttpClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.ResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHttpClient
implements IHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(NativeHttpClient.class);
    private static final String KEYWORDS_CONNECT_TIMED_OUT = "connect timed out";
    private static final String KEYWORDS_READ_TIMED_OUT = "Read timed out";
    private int _maxRetryTimes = 0;
    private String _authCode;
    private HttpProxy _proxy;

    public NativeHttpClient(String authCode) {
        this(authCode, 3, null);
    }

    public NativeHttpClient(String authCode, int maxRetryTimes, HttpProxy proxy) {
        this._maxRetryTimes = maxRetryTimes;
        LOG.info("Created instance with _maxRetryTimes = " + this._maxRetryTimes);
        this._authCode = authCode;
        this._proxy = proxy;
        if (null != this._proxy && this._proxy.isAuthenticationNeeded()) {
            Authenticator.setDefault(new SimpleProxyAuthenticator(this._proxy.getUsername(), this._proxy.getPassword()));
        }
        this.initSSL();
    }

    @Override
    public ResponseWrapper sendGet(String url) throws APIConnectionException, APIRequestException {
        return this.sendGet(url, null);
    }

    public ResponseWrapper sendGet(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.GET);
    }

    @Override
    public ResponseWrapper sendDelete(String url) throws APIConnectionException, APIRequestException {
        return this.sendDelete(url, null);
    }

    public ResponseWrapper sendDelete(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.DELETE);
    }

    @Override
    public ResponseWrapper sendPost(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.POST);
    }

    @Override
    public ResponseWrapper sendPut(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.PUT);
    }

    public ResponseWrapper doRequest(String url, String content, IHttpClient.RequestMethod method) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = null;
        int retryTimes = 0;
        while (true) {
            try {
                response = this._doRequest(url, content, method);
            }
            catch (SocketTimeoutException e) {
                if (KEYWORDS_READ_TIMED_OUT.equals(e.getMessage())) {
                    throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
                }
                if (retryTimes >= this._maxRetryTimes) {
                    throw new APIConnectionException("connect timed out. \nConnect to JPush Server timed out, and already retried some times. \nPlease ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, retryTimes);
                }
                LOG.debug("connect timed out - retry again - " + (retryTimes + 1));
                ++retryTimes;
                continue;
            }
            break;
        }
        return response;
    }

    private ResponseWrapper _doRequest(String url, String content, IHttpClient.RequestMethod method) throws APIConnectionException, APIRequestException, SocketTimeoutException {
        ResponseWrapper wrapper;
        block33: {
            LOG.debug("Send request - " + method.toString() + " " + url);
            if (null != content) {
                LOG.debug("Request Content - " + content);
            }
            HttpURLConnection conn = null;
            OutputStream out = null;
            StringBuffer sb = new StringBuffer();
            wrapper = new ResponseWrapper();
            try {
                URL aUrl = new URL(url);
                if (null != this._proxy) {
                    conn = (HttpURLConnection)aUrl.openConnection(this._proxy.getNetProxy());
                    if (this._proxy.isAuthenticationNeeded()) {
                        conn.setRequestProperty("Proxy-Authorization", this._proxy.getProxyAuthorization());
                    }
                } else {
                    conn = (HttpURLConnection)aUrl.openConnection();
                }
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(30000);
                conn.setUseCaches(false);
                conn.setRequestMethod(method.name());
                conn.setRequestProperty("User-Agent", "JPush-API-Java-Client");
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setRequestProperty("Charset", "UTF-8");
                conn.setRequestProperty("Authorization", this._authCode);
                conn.setRequestProperty("Content-Type", "application/json");
                if (null == content) {
                    conn.setDoOutput(false);
                } else {
                    conn.setDoOutput(true);
                    byte[] data = content.getBytes("UTF-8");
                    conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                    out = conn.getOutputStream();
                    out.write(data);
                    out.flush();
                }
                int status = conn.getResponseCode();
                InputStream in = null;
                in = status / 100 == 2 ? conn.getInputStream() : conn.getErrorStream();
                if (null != in) {
                    int len;
                    InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                    char[] buff = new char[1024];
                    while ((len = reader.read(buff)) > 0) {
                        sb.append(buff, 0, len);
                    }
                }
                String responseContent = sb.toString();
                wrapper.responseCode = status;
                wrapper.responseContent = responseContent;
                String quota = conn.getHeaderField("X-Rate-Limit-Limit");
                String remaining = conn.getHeaderField("X-Rate-Limit-Remaining");
                String reset = conn.getHeaderField("X-Rate-Limit-Reset");
                wrapper.setRateLimit(quota, remaining, reset);
                if (status >= 200 && status < 300) {
                    LOG.debug("Succeed to get response OK - responseCode:" + status);
                    LOG.debug("Response Content - " + responseContent);
                    break block33;
                }
                if (status >= 300 && status < 400) {
                    LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + responseContent);
                    break block33;
                }
                LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + responseContent);
                switch (status) {
                    case 400: {
                        LOG.error("Your request params is invalid. Please check them according to error message.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 401: {
                        LOG.error("Authentication failed! Please check authentication params according to docs.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 403: {
                        LOG.error("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 404: {
                        LOG.error("Request page is not found! Maybe your params is invalid.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 410: {
                        LOG.error("Request resource is no longer in service. Please according to notice on official website.");
                        wrapper.setErrorObject();
                    }
                    case 429: {
                        LOG.error("Too many requests! Please review your appkey's request quota.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 500: 
                    case 502: 
                    case 503: 
                    case 504: {
                        LOG.error("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                        break;
                    }
                    default: {
                        LOG.error("Unexpected response.");
                    }
                }
                throw new APIRequestException(wrapper);
            }
            catch (SocketTimeoutException e) {
                if (e.getMessage().contains(KEYWORDS_CONNECT_TIMED_OUT)) {
                    throw e;
                }
                if (e.getMessage().contains(KEYWORDS_READ_TIMED_OUT)) {
                    throw new SocketTimeoutException(KEYWORDS_READ_TIMED_OUT);
                }
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", e);
            }
            catch (IOException e) {
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close stream.", (Throwable)e);
                    }
                }
                if (null != conn) {
                    conn.disconnect();
                }
            }
        }
        return wrapper;
    }

    protected void initSSL() {
        TrustManager[] tmCerts = new TrustManager[]{new SimpleTrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tmCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            SimpleHostnameVerifier hostnameVerifier = new SimpleHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception e) {
            LOG.error("Init SSL error", (Throwable)e);
        }
    }

    private static class SimpleProxyAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public SimpleProxyAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    private static class SimpleTrustManager
    implements TrustManager,
    X509TrustManager {
        private SimpleTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class SimpleHostnameVerifier
    implements HostnameVerifier {
        private SimpleHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

