/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class IosAlert
implements PushModel {
    private final String title;
    private final String body;
    private final String title_loc_key;
    private final String[] title_loc_args;
    private final String action_loc_key;
    private final String loc_key;
    private final String[] loc_args;
    private final String launch_image;

    private IosAlert(String title, String body, String title_loc_key, String[] title_loc_args, String action_loc_key, String loc_key, String[] loc_args, String launch_image) {
        this.title = title;
        this.body = body;
        this.title_loc_key = title_loc_key;
        this.title_loc_args = title_loc_args;
        this.action_loc_key = action_loc_key;
        this.loc_key = loc_key;
        this.loc_args = loc_args;
        this.launch_image = launch_image;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        int i;
        JsonArray args;
        JsonObject json = new JsonObject();
        if (StringUtils.isNotEmpty(this.title)) {
            json.addProperty("title", this.title);
        }
        if (StringUtils.isNotEmpty(this.body)) {
            json.addProperty("body", this.body);
        }
        if (StringUtils.isNotEmpty(this.title_loc_key)) {
            json.addProperty("title-loc-key", this.title_loc_key);
            if (null != this.title_loc_args && this.title_loc_args.length > 0) {
                args = new JsonArray();
                for (i = 0; i < this.title_loc_args.length; ++i) {
                    args.add((JsonElement)new JsonPrimitive(this.title_loc_args[i]));
                }
                json.add("title-loc-args", (JsonElement)args);
            }
        }
        if (StringUtils.isNotEmpty(this.action_loc_key)) {
            json.addProperty("action-loc-key", this.action_loc_key);
        }
        if (StringUtils.isNotEmpty(this.loc_key)) {
            json.addProperty("loc-key", this.loc_key);
            if (null != this.loc_args && this.loc_args.length > 0) {
                args = new JsonArray();
                for (i = 0; i < this.loc_args.length; ++i) {
                    args.add((JsonElement)new JsonPrimitive(this.loc_args[i]));
                }
                json.add("loc-args", (JsonElement)args);
            }
        }
        if (StringUtils.isNotEmpty(this.launch_image)) {
            json.addProperty("launch-image", this.launch_image);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String title;
        private String body;
        private String title_loc_key;
        private String[] title_loc_args;
        private String action_loc_key;
        private String loc_key;
        private String[] loc_args;
        private String launch_image;

        public Builder setTitleAndBody(String title, String body) {
            this.title = title;
            this.body = body;
            return this;
        }

        public Builder setTitleLoc(String title_loc_key, String ... title_loc_args) {
            this.title_loc_key = title_loc_key;
            this.title_loc_args = title_loc_args;
            return this;
        }

        public Builder setActionLocKey(String action_loc_key) {
            this.action_loc_key = action_loc_key;
            return this;
        }

        public Builder setLoc(String loc_key, String ... loc_args) {
            this.loc_key = loc_key;
            this.loc_args = loc_args;
            return this;
        }

        public Builder setLaunchImage(String launch_image) {
            this.launch_image = launch_image;
            return this;
        }

        public IosAlert build() {
            return new IosAlert(this.title, this.body, this.title_loc_key, this.title_loc_args, this.action_loc_key, this.loc_key, this.loc_args, this.launch_image);
        }
    }
}

