/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jsms.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class RecipientPayload
implements IModel {
    private static final String MOBILE = "mobile";
    private static final String TEMP_PARA = "temp_para";
    private String mobile;
    private Map<String, String> temp_para;
    private Gson gson = new Gson();

    public RecipientPayload(String mobile, Map<String, String> tempPara) {
        this.mobile = mobile;
        this.temp_para = tempPara;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject jsonObject = new JsonObject();
        if (null != this.mobile) {
            jsonObject.addProperty(MOBILE, this.mobile);
        }
        JsonObject tempJson = null;
        if (null != this.temp_para) {
            tempJson = new JsonObject();
            for (String key : this.temp_para.keySet()) {
                if (this.temp_para.get(key) != null) {
                    tempJson.add(key, (JsonElement)new JsonPrimitive(this.temp_para.get(key)));
                    continue;
                }
                tempJson.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != tempJson) {
            jsonObject.add(TEMP_PARA, (JsonElement)tempJson);
        }
        return jsonObject;
    }

    public String toString() {
        return this.gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String mobile;
        private Map<String, String> tempPara;

        public Builder setMobile(String mobileNumber) {
            this.mobile = mobileNumber.trim();
            return this;
        }

        public Builder setTempPara(Map<String, String> temp_para) {
            Preconditions.checkArgument((null != temp_para ? 1 : 0) != 0, (Object)"temp_para should not be null.");
            if (null == this.tempPara) {
                this.tempPara = new HashMap<String, String>();
            }
            for (String key : temp_para.keySet()) {
                this.tempPara.put(key, temp_para.get(key));
            }
            return this;
        }

        public Builder addTempPara(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.tempPara) {
                this.tempPara = new HashMap<String, String>();
            }
            this.tempPara.put(key, value);
            return this;
        }

        public RecipientPayload build() {
            Preconditions.checkArgument((null != this.mobile ? 1 : 0) != 0, (Object)"mobile number should not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.mobile), (Object)"mobile number should not be empty");
            return new RecipientPayload(this.mobile, this.tempPara);
        }
    }
}

