/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jsms.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class SMSPayload
implements IModel {
    private static String MOBILE = "mobile";
    private static String SIGN_ID = "sign_id";
    private static String TEMP_ID = "temp_id";
    private static String TTL = "ttl";
    private static String TEMP_PARA = "temp_para";
    private static String CODE = "code";
    private static String VOICE_LANG = "voice_lang";
    private String mobile;
    private int sign_id;
    private int temp_id;
    private int ttl;
    private String code;
    private int voice_lang = -1;
    private final Map<String, String> temp_para;
    private static Gson gson = new Gson();

    private SMSPayload(String mobileNumber, int signId, int tempId, int ttl, String code, int voiceLang, Map<String, String> temp_para) {
        this.mobile = mobileNumber;
        this.sign_id = signId;
        this.temp_id = tempId;
        this.ttl = ttl;
        this.code = code;
        this.voice_lang = voiceLang;
        this.temp_para = temp_para;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.mobile) {
            json.addProperty(MOBILE, this.mobile);
        }
        if (this.sign_id > 0) {
            json.addProperty(SIGN_ID, (Number)this.sign_id);
        }
        if (this.temp_id > 0) {
            json.addProperty(TEMP_ID, (Number)this.temp_id);
        }
        if (this.ttl > 0) {
            json.addProperty(TTL, (Number)this.ttl);
        }
        if (this.voice_lang != -1) {
            json.addProperty(VOICE_LANG, (Number)this.voice_lang);
        }
        if (this.code != null) {
            json.addProperty(CODE, this.code);
        }
        JsonObject tempJson = null;
        if (null != this.temp_para) {
            tempJson = new JsonObject();
            for (String key : this.temp_para.keySet()) {
                if (this.temp_para.get(key) != null) {
                    tempJson.add(key, (JsonElement)new JsonPrimitive(this.temp_para.get(key)));
                    continue;
                }
                tempJson.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != tempJson) {
            json.add(TEMP_PARA, (JsonElement)tempJson);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String mobile;
        private int sign_id;
        private int temp_id;
        private int ttl;
        private String code;
        private int voice_lang = -1;
        private Map<String, String> tempParaBuilder;

        public Builder setMobileNumber(String mobileNumber) {
            this.mobile = mobileNumber.trim();
            return this;
        }

        public Builder setSignId(int signId) {
            this.sign_id = signId;
            return this;
        }

        public Builder setTempId(int tempId) {
            this.temp_id = tempId;
            return this;
        }

        public Builder setTTL(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setCode(String code) {
            Preconditions.checkArgument((code.length() >= 4 && code.length() <= 8 ? 1 : 0) != 0, (Object)"Code's length should between 4 and 8");
            this.code = code;
            return this;
        }

        public Builder setVoiceLang(int voiceLang) {
            Preconditions.checkArgument((voiceLang == 0 || voiceLang == 1 || voiceLang == 2 ? 1 : 0) != 0, (Object)"Illegal voice lang. Voice lang should be 0, or 1 or 2");
            this.voice_lang = voiceLang;
            return this;
        }

        public Builder setTempPara(Map<String, String> temp_para) {
            Preconditions.checkArgument((null != temp_para ? 1 : 0) != 0, (Object)"temp_para should not be null.");
            if (null == this.tempParaBuilder) {
                this.tempParaBuilder = new HashMap<String, String>();
            }
            for (String key : temp_para.keySet()) {
                this.tempParaBuilder.put(key, temp_para.get(key));
            }
            return this;
        }

        public Builder addTempPara(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.tempParaBuilder) {
                this.tempParaBuilder = new HashMap<String, String>();
            }
            this.tempParaBuilder.put(key, value);
            return this;
        }

        public SMSPayload build() {
            Preconditions.checkArgument((null != this.mobile ? 1 : 0) != 0, (Object)"mobile number should not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.mobile), (Object)"mobile number should not be empty");
            Preconditions.checkArgument((this.ttl >= 0 ? 1 : 0) != 0, (Object)"ttl should not less 0");
            Preconditions.checkArgument((this.temp_id >= 0 ? 1 : 0) != 0, (Object)"temp id should not less 0");
            return new SMSPayload(this.mobile, this.sign_id, this.temp_id, this.ttl, this.code, this.voice_lang, this.tempParaBuilder);
        }
    }
}

