/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jsms.api.SendSMSResult;
import cn.jsms.api.ValidSMSResult;
import cn.jsms.api.account.AccountBalanceResult;
import cn.jsms.api.account.AppBalanceResult;
import cn.jsms.api.common.JSMSConfig;
import cn.jsms.api.common.model.BatchSMSPayload;
import cn.jsms.api.common.model.BatchSMSResult;
import cn.jsms.api.common.model.SMSPayload;
import cn.jsms.api.schedule.model.ScheduleResult;
import cn.jsms.api.schedule.model.ScheduleSMSPayload;
import cn.jsms.api.schedule.model.ScheduleSMSResult;
import cn.jsms.api.template.SendTempSMSResult;
import cn.jsms.api.template.TempSMSResult;
import cn.jsms.api.template.TemplatePayload;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;

public class SMSClient {
    private static String SMS_CODE = "code";
    private String _baseUrl;
    private String _smsCodePath;
    private String _validPath;
    private String _voiceCodePath;
    private String _shortMsgPath;
    private String _schedulePath;
    private String _accountPath;
    private String _tempMsgPath;
    private IHttpClient _httpClient;

    public SMSClient(String masterSecret, String appkey) {
        this(masterSecret, appkey, null, JSMSConfig.getInstance());
    }

    public SMSClient(String masterSecret, String appkey, HttpProxy proxy, JSMSConfig conf) {
        ServiceHelper.checkBasic((String)appkey, (String)masterSecret);
        this._baseUrl = (String)conf.get("sms.api.host.name");
        this._smsCodePath = (String)conf.get("sms.code.path");
        this._validPath = (String)conf.get("sms.valid.path");
        this._voiceCodePath = (String)conf.get("sms.voice.code.path");
        this._shortMsgPath = (String)conf.get("sms.message.path");
        this._tempMsgPath = (String)conf.get("sms.template.path");
        this._schedulePath = (String)conf.get("sms.schedule.path");
        this._accountPath = (String)conf.get("sms.account.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appkey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf.getClientConfig());
    }

    public SendSMSResult sendSMSCode(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._smsCodePath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public ValidSMSResult sendValidSMSCode(String msgId, String code) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != msgId ? 1 : 0) != 0, (Object)"Message id should not be null");
        Pattern codePattern = Pattern.compile("^[0-9]{6}");
        Preconditions.checkArgument((boolean)codePattern.matcher(code).matches(), (Object)"The verification code shoude be consist of six number");
        JsonObject json = new JsonObject();
        json.addProperty(SMS_CODE, code);
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._smsCodePath + "/" + msgId + this._validPath, json.toString());
        return (ValidSMSResult)ValidSMSResult.fromResponse((ResponseWrapper)response, ValidSMSResult.class);
    }

    public SendSMSResult sendVoiceSMSCode(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._voiceCodePath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public SendSMSResult sendTemplateSMS(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._shortMsgPath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public BatchSMSResult sendBatchTemplateSMS(BatchSMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"BatchSMSPayload should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._shortMsgPath + "/batch", payload.toString());
        return (BatchSMSResult)BatchSMSResult.fromResponse((ResponseWrapper)responseWrapper, BatchSMSResult.class);
    }

    public void setHttpClient(IHttpClient client) {
        this._httpClient = client;
    }

    public void close() {
        if (this._httpClient != null && this._httpClient instanceof NettyHttpClient) {
            ((NettyHttpClient)this._httpClient).close();
        }
    }

    public ScheduleResult sendScheduleSMS(ScheduleSMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != payload.getMobile() ? 1 : 0) != 0, (Object)"Mobile should not be null");
        Preconditions.checkArgument((boolean)StringUtils.isMobileNumber((String)payload.getMobile()), (Object)"Invalid mobile number");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._schedulePath, payload.toString());
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)responseWrapper, ScheduleResult.class);
    }

    public ScheduleResult updateScheduleSMS(ScheduleSMSPayload payload, String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        Preconditions.checkArgument((null != payload.getMobile() ? 1 : 0) != 0, (Object)"Mobile should not be null");
        Preconditions.checkArgument((boolean)StringUtils.isMobileNumber((String)payload.getMobile()), (Object)"Invalid mobile number");
        ResponseWrapper responseWrapper = this._httpClient.sendPut(this._baseUrl + this._schedulePath + "/" + scheduleId, payload.toString());
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)responseWrapper, ScheduleResult.class);
    }

    public BatchSMSResult sendBatchScheduleSMS(ScheduleSMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != payload.getRecipients() ? 1 : 0) != 0, (Object)"Recipients should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._schedulePath + "/batch", payload.toString());
        return (BatchSMSResult)BatchSMSResult.fromResponse((ResponseWrapper)responseWrapper, BatchSMSResult.class);
    }

    public BatchSMSResult updateBatchScheduleSMS(ScheduleSMSPayload payload, String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != payload.getRecipients() ? 1 : 0) != 0, (Object)"Recipients should not be null");
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPut(this._baseUrl + this._schedulePath + "/batch/" + scheduleId, payload.toString());
        return (BatchSMSResult)BatchSMSResult.fromResponse((ResponseWrapper)responseWrapper, BatchSMSResult.class);
    }

    public ScheduleSMSResult getScheduleSMS(String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._schedulePath + "/" + scheduleId);
        return (ScheduleSMSResult)ScheduleSMSResult.fromResponse((ResponseWrapper)responseWrapper, ScheduleSMSResult.class);
    }

    public ResponseWrapper deleteScheduleSMS(String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        return this._httpClient.sendDelete(this._baseUrl + this._schedulePath + "/" + scheduleId);
    }

    public AccountBalanceResult getSMSBalance() throws APIConnectionException, APIRequestException {
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._accountPath + "/dev");
        return (AccountBalanceResult)AccountBalanceResult.fromResponse((ResponseWrapper)responseWrapper, AccountBalanceResult.class);
    }

    public AppBalanceResult getAppSMSBalance() throws APIConnectionException, APIRequestException {
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._accountPath + "/app");
        return (AppBalanceResult)AppBalanceResult.fromResponse((ResponseWrapper)responseWrapper, AppBalanceResult.class);
    }

    public SendTempSMSResult createTemplate(TemplatePayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Template payload should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._tempMsgPath, payload.toString());
        return (SendTempSMSResult)SendTempSMSResult.fromResponse((ResponseWrapper)responseWrapper, SendTempSMSResult.class);
    }

    public SendTempSMSResult updateTemplate(TemplatePayload payload, int tempId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Template payload should not be null");
        Preconditions.checkArgument((tempId > 0 ? 1 : 0) != 0, (Object)"temp id is invalid");
        ResponseWrapper responseWrapper = this._httpClient.sendPut(this._baseUrl + this._tempMsgPath + "/" + tempId, payload.toString());
        return (SendTempSMSResult)SendTempSMSResult.fromResponse((ResponseWrapper)responseWrapper, SendTempSMSResult.class);
    }

    public TempSMSResult checkTemplate(int tempId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((tempId > 0 ? 1 : 0) != 0, (Object)"temp id is invalid");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._tempMsgPath + "/" + tempId);
        return (TempSMSResult)TempSMSResult.fromResponse((ResponseWrapper)responseWrapper, TempSMSResult.class);
    }

    public ResponseWrapper deleteTemplate(int tempId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((tempId > 0 ? 1 : 0) != 0, (Object)"temp id is invalid");
        return this._httpClient.sendDelete(this._baseUrl + this._tempMsgPath + "/" + tempId);
    }
}

