/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jsms.api.common.model.IModel;
import cn.jsms.api.common.model.RecipientPayload;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class BatchSMSPayload
implements IModel {
    private static String TEMP_ID = "temp_id";
    private static String RECIPIENTS = "recipients";
    private int temp_id;
    private static Gson gson = new Gson();
    private JsonArray recipients;

    public BatchSMSPayload(int tempId, JsonArray recipients) {
        this.temp_id = tempId;
        this.recipients = recipients;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject jsonObject = new JsonObject();
        if (this.temp_id > 0) {
            jsonObject.addProperty(TEMP_ID, (Number)this.temp_id);
        }
        if (null != this.recipients && this.recipients.size() > 0) {
            jsonObject.add(RECIPIENTS, (JsonElement)this.recipients);
        }
        return jsonObject;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private int temp_id;
        private JsonArray recipients = new JsonArray();

        public Builder setTempId(int tempId) {
            this.temp_id = tempId;
            return this;
        }

        public Builder setRecipients(RecipientPayload ... recipients) {
            if (recipients == null) {
                return this;
            }
            for (RecipientPayload recipientPayload : recipients) {
                this.recipients.add(recipientPayload.toJSON());
            }
            return this;
        }

        public Builder addRecipient(RecipientPayload recipientPayload) {
            Preconditions.checkArgument((null != recipientPayload ? 1 : 0) != 0, (Object)"RecipientPayload should not be null");
            this.recipients.add(recipientPayload.toJSON());
            return this;
        }

        public BatchSMSPayload build() {
            Preconditions.checkArgument((this.temp_id >= 0 ? 1 : 0) != 0, (Object)"temp id should not less 0");
            return new BatchSMSPayload(this.temp_id, this.recipients);
        }
    }
}

