/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.login.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.SysUserServiceApi;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.UserExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.OnlineUserItem;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.OnlineUserResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OnlineUserService {
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private SysUserServiceApi sysUserServiceApi;

    public OnlineUserResult getOnlineUserList(String searchText) {
        OnlineUserResult onlineUserResult = new OnlineUserResult();
        List loginUsers = this.sessionManagerApi.onlineUserList();
        if (ObjectUtil.isEmpty((Object)loginUsers)) {
            return new OnlineUserResult();
        }
        onlineUserResult.setTotalUserCount(loginUsers.size());
        ArrayList<OnlineUserItem> onlineUserInfos = new ArrayList();
        for (LoginUser loginUser : loginUsers) {
            OnlineUserItem onlineUserInfo = new OnlineUserItem();
            onlineUserInfo.setUserId(loginUser.getUserId());
            onlineUserInfo.setToken(loginUser.getToken());
            onlineUserInfo.setLoginIp(loginUser.getLoginIp());
            onlineUserInfo.setLoginTime(loginUser.getLoginTime());
            onlineUserInfos.add(onlineUserInfo);
        }
        if (StrUtil.isBlank((CharSequence)searchText)) {
            if (onlineUserInfos.size() > 10) {
                onlineUserInfos = onlineUserInfos.subList(0, 9);
            }
            for (OnlineUserItem onlineUserInfo : onlineUserInfos) {
                OnlineUserItem userNameAccountInfo = this.sysUserServiceApi.getUserNameAccountInfo(onlineUserInfo.getUserId());
                onlineUserInfo.setAccount(userNameAccountInfo.getAccount());
                onlineUserInfo.setRealName(userNameAccountInfo.getRealName());
            }
            onlineUserResult.setOnlineUserList(onlineUserInfos);
            return onlineUserResult;
        }
        List resultUserList = this.sysUserServiceApi.getUserNameAccountInfoListByCondition(onlineUserInfos, searchText);
        onlineUserResult.setOnlineUserList(resultUserList);
        return onlineUserResult;
    }

    public void offlineUser(OnlineUserItem onlineUserInfo) throws ServiceException {
        if (!LoginContext.me().getSuperAdminFlag()) {
            throw new ServiceException((AbstractExceptionEnum)UserExceptionEnum.KICK_OFF_ERROR);
        }
        this.sessionManagerApi.removeSession(onlineUserInfo.getToken());
    }
}

