/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.login.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.PermissionServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceUrlParam;
import cn.stylefeng.roses.kernel.sys.api.ResourceServiceApi;
import cn.stylefeng.roses.kernel.sys.modular.login.service.UserPermissionService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PermissionCheckServiceImpl
implements PermissionServiceApi {
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private ResourceServiceApi resourceServiceApi;
    @Resource
    private UserPermissionService userPermissionService;

    public void checkPermission(String token, String requestUrl) {
        if (StrUtil.isEmpty((CharSequence)token)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
        }
        LoginUser loginUser = this.sessionManagerApi.getSession(token);
        if (loginUser == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
        }
        ResourceDefinition resourceDefinition = this.resourceServiceApi.getResourceByUrl(new ResourceUrlParam(requestUrl));
        if (resourceDefinition == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.CANT_REQUEST_UN_OPEN_API, new Object[]{requestUrl});
        }
        if (!resourceDefinition.getRequiredPermissionFlag().booleanValue()) {
            return;
        }
        String permissionCode = resourceDefinition.getPermissionCode();
        if (ObjectUtil.isEmpty((Object)permissionCode)) {
            return;
        }
        List<String> userPermissionCodeList = this.userPermissionService.getUserPermissionCodeList(loginUser);
        if (ObjectUtil.isNotEmpty(userPermissionCodeList) && userPermissionCodeList.contains(permissionCode)) {
            return;
        }
        throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.PERMISSION_RES_VALIDATE_ERROR);
    }
}

