/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.menu.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.event.sdk.publish.BusinessEventPublisher;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveMenuCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.menu.enums.SysMenuOptionsExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.menu.factory.MenuOptionsValidateFactory;
import cn.stylefeng.roses.kernel.sys.modular.menu.mapper.SysMenuOptionsMapper;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.request.SysMenuOptionsRequest;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuOptionsServiceImpl
extends ServiceImpl<SysMenuOptionsMapper, SysMenuOptions>
implements SysMenuOptionsService,
RemoveMenuCallbackApi {
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource(name="menuCodeCache")
    private CacheOperatorApi<String> menuCodeCache;

    @Override
    public void add(SysMenuOptionsRequest sysMenuOptionsRequest) {
        MenuOptionsValidateFactory.validateMenuOptionsParam(sysMenuOptionsRequest);
        SysMenuOptions sysMenuOptions = new SysMenuOptions();
        BeanUtil.copyProperties((Object)((Object)sysMenuOptionsRequest), (Object)((Object)sysMenuOptions), (String[])new String[0]);
        Map menuAppId = this.sysMenuService.getMenuAppId(ListUtil.list((boolean)false, (Object[])new Long[]{sysMenuOptionsRequest.getMenuId()}));
        Long appId = (Long)menuAppId.get(sysMenuOptionsRequest.getMenuId());
        sysMenuOptions.setAppId(appId);
        this.save((Object)sysMenuOptions);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysMenuOptionsRequest sysMenuOptionsRequest) {
        SysMenuOptions sysMenuOptions = this.querySysMenuOptions(sysMenuOptionsRequest);
        this.removeById(sysMenuOptions.getMenuOptionId());
        this.sysRoleMenuOptionsService.removeRoleBindOptions(sysMenuOptionsRequest.getMenuOptionId());
        BusinessEventPublisher.publishEvent((String)"MENU_OPTIONS_UPDATE_EVENT", (Object)sysMenuOptions.getMenuOptionId());
    }

    @Override
    public void edit(SysMenuOptionsRequest sysMenuOptionsRequest) {
        MenuOptionsValidateFactory.validateMenuOptionsParam(sysMenuOptionsRequest);
        SysMenuOptions sysMenuOptions = this.querySysMenuOptions(sysMenuOptionsRequest);
        BeanUtil.copyProperties((Object)((Object)sysMenuOptionsRequest), (Object)((Object)sysMenuOptions), (String[])new String[0]);
        this.updateById((Object)sysMenuOptions);
        BusinessEventPublisher.publishEvent((String)"MENU_OPTIONS_UPDATE_EVENT", (Object)sysMenuOptions.getMenuOptionId());
    }

    @Override
    public SysMenuOptions detail(SysMenuOptionsRequest sysMenuOptionsRequest) {
        return this.querySysMenuOptions(sysMenuOptionsRequest);
    }

    @Override
    public PageResult<SysMenuOptions> findPage(SysMenuOptionsRequest sysMenuOptionsRequest) {
        LambdaQueryWrapper<SysMenuOptions> wrapper = this.createWrapper(sysMenuOptionsRequest);
        wrapper.select(new SFunction[]{SysMenuOptions::getOptionName, SysMenuOptions::getOptionCode, SysMenuOptions::getMenuId, SysMenuOptions::getMenuOptionId});
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SysMenuOptions> getTotalMenuOptionsList() {
        return this.getTotalMenuOptionsList(null);
    }

    @Override
    public List<SysMenuOptions> getTotalMenuOptionsList(Set<Long> roleLimitMenuIdsAndOptionIds) {
        LambdaQueryWrapper sysMenuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuOptionsLambdaQueryWrapper.select(new SFunction[]{SysMenuOptions::getMenuOptionId, SysMenuOptions::getMenuId, SysMenuOptions::getAppId, SysMenuOptions::getOptionName});
        if (ObjectUtil.isNotEmpty(roleLimitMenuIdsAndOptionIds)) {
            sysMenuOptionsLambdaQueryWrapper.in(SysMenuOptions::getMenuOptionId, roleLimitMenuIdsAndOptionIds);
        }
        return this.list((Wrapper)sysMenuOptionsLambdaQueryWrapper);
    }

    @Override
    public List<String> getOptionsCodeList(List<Long> optionsIdList) {
        ArrayList<String> result = new ArrayList<String>();
        if (ObjectUtil.isEmpty(optionsIdList)) {
            return result;
        }
        for (Long optionsId : optionsIdList) {
            String optionsIdKey = optionsId.toString();
            String cachedCode = (String)this.menuCodeCache.get(optionsIdKey);
            if (ObjectUtil.isNotEmpty((Object)cachedCode)) {
                result.add(cachedCode);
                continue;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysMenuOptions::getMenuOptionId, (Object)optionsId);
            queryWrapper.select(new SFunction[]{SysMenuOptions::getOptionCode});
            SysMenuOptions sysMenuOptions = (SysMenuOptions)((Object)this.getOne((Wrapper)queryWrapper, false));
            if (sysMenuOptions == null) continue;
            String optionCodeQueryResult = sysMenuOptions.getOptionCode();
            result.add(optionCodeQueryResult);
            this.menuCodeCache.put(optionsIdKey, (Object)optionCodeQueryResult, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return result;
    }

    @Override
    public List<SysMenuOptions> findList(SysMenuOptionsRequest sysMenuOptionsRequest) {
        LambdaQueryWrapper<SysMenuOptions> wrapper = this.createWrapper(sysMenuOptionsRequest);
        wrapper.select(new SFunction[]{SysMenuOptions::getOptionName, SysMenuOptions::getOptionCode, SysMenuOptions::getMenuId, SysMenuOptions::getMenuOptionId});
        return this.list((Wrapper)wrapper);
    }

    public void removeMenuAction(Set<Long> beRemovedMenuIdList) {
        LambdaQueryWrapper menuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        menuOptionsLambdaQueryWrapper.in(SysMenuOptions::getMenuId, beRemovedMenuIdList);
        this.remove((Wrapper)menuOptionsLambdaQueryWrapper);
    }

    private SysMenuOptions querySysMenuOptions(SysMenuOptionsRequest sysMenuOptionsRequest) {
        SysMenuOptions sysMenuOptions = (SysMenuOptions)((Object)this.getById(sysMenuOptionsRequest.getMenuOptionId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysMenuOptions))) {
            throw new ServiceException((AbstractExceptionEnum)SysMenuOptionsExceptionEnum.SYS_MENU_OPTIONS_NOT_EXISTED);
        }
        return sysMenuOptions;
    }

    private LambdaQueryWrapper<SysMenuOptions> createWrapper(SysMenuOptionsRequest sysMenuOptionsRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long menuId = sysMenuOptionsRequest.getMenuId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)menuId), SysMenuOptions::getMenuId, (Object)menuId);
        String searchText = sysMenuOptionsRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.nested(wrap -> {
                wrap.like(SysMenuOptions::getOptionCode, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(SysMenuOptions::getOptionName, (Object)searchText);
            });
        }
        return queryWrapper;
    }
}

