/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.menu.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.event.sdk.publish.BusinessEventPublisher;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.tree.buildpids.PidStructureBuildUtil;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveMenuCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.api.pojo.menu.UserAppMenuInfo;
import cn.stylefeng.roses.kernel.sys.modular.app.service.SysAppService;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.enums.SysMenuExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.menu.factory.MenuFactory;
import cn.stylefeng.roses.kernel.sys.modular.menu.factory.MenuTreeFactory;
import cn.stylefeng.roses.kernel.sys.modular.menu.factory.MenuValidateFactory;
import cn.stylefeng.roses.kernel.sys.modular.menu.mapper.SysMenuMapper;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.request.SysMenuRequest;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.response.AppGroupDetail;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.menu.util.MenuOrderFixUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuMapper, SysMenu>
implements SysMenuService {
    @Resource
    private SysAppService sysAppService;
    @Resource
    private DbOperatorApi dbOperatorApi;
    @Resource(name="menuCodeCache")
    private CacheOperatorApi<String> menuCodeCache;

    @Override
    public void add(SysMenuRequest sysMenuRequest) {
        MenuValidateFactory.validateAddMenuParam(sysMenuRequest);
        SysMenu sysMenu = new SysMenu();
        BeanUtil.copyProperties((Object)((Object)sysMenuRequest), (Object)((Object)sysMenu), (String[])new String[0]);
        String pids = this.createPids(sysMenuRequest.getMenuParentId());
        sysMenu.setMenuPids(pids);
        this.save((Object)sysMenu);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysMenuRequest sysMenuRequest) {
        Long menuId = sysMenuRequest.getMenuId();
        Set totalMenuIds = this.dbOperatorApi.findSubListByParentId("sys_menu", "menu_pids", "menu_id", menuId);
        totalMenuIds.add(menuId);
        this.removeByIds(totalMenuIds);
        Map removeMenuCallbackApiMap = SpringUtil.getBeansOfType(RemoveMenuCallbackApi.class);
        for (RemoveMenuCallbackApi removeMenuCallbackApi : removeMenuCallbackApiMap.values()) {
            removeMenuCallbackApi.removeMenuAction(totalMenuIds);
        }
        BusinessEventPublisher.publishEvent((String)"MENU_UPDATE_EVENT", (Object)menuId);
    }

    @Override
    public void edit(SysMenuRequest sysMenuRequest) {
        sysMenuRequest.setMenuParentId(null);
        sysMenuRequest.setAppId(null);
        MenuValidateFactory.validateAddMenuParam(sysMenuRequest);
        SysMenu sysMenu = this.querySysMenu(sysMenuRequest);
        BeanUtil.copyProperties((Object)((Object)sysMenuRequest), (Object)((Object)sysMenu), (String[])new String[0]);
        this.updateById((Object)sysMenu);
        BusinessEventPublisher.publishEvent((String)"MENU_UPDATE_EVENT", (Object)sysMenu.getMenuId());
    }

    @Override
    public SysMenu detail(SysMenuRequest sysMenuRequest) {
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.eq(SysMenu::getMenuId, (Object)sysMenuRequest.getMenuId());
        sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getAppId, SysMenu::getMenuName, SysMenu::getMenuCode, SysMenu::getMenuSort, SysMenu::getMenuType, SysMenu::getAntdvComponent, SysMenu::getAntdvRouter, SysMenu::getAntdvVisible, SysMenu::getAntdvActiveUrl, SysMenu::getAntdvLinkUrl, SysMenu::getAntdvIcon, SysMenu::getMenuParentId, SysMenu::getAppDesignBusinessId});
        SysMenu sysMenu = (SysMenu)((Object)this.getOne((Wrapper)sysMenuLambdaQueryWrapper, false));
        if (ObjectUtil.isNotEmpty((Object)((Object)sysMenu)) && ObjectUtil.isNotEmpty((Object)sysMenu.getMenuParentId())) {
            if (sysMenu.getMenuParentId().equals(TreeConstants.DEFAULT_PARENT_ID)) {
                sysMenu.setMenuParentName("\u6839\u8282\u70b9");
            } else {
                SysMenu parentMenu = (SysMenu)((Object)this.getById(sysMenu.getMenuParentId()));
                sysMenu.setMenuParentName(parentMenu.getMenuName());
            }
        }
        return sysMenu;
    }

    @Override
    public boolean validateMenuBindApp(Set<Long> appIdList) {
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.in(SysMenu::getAppId, appIdList);
        sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuId});
        long count = this.count((Wrapper)sysMenuLambdaQueryWrapper);
        return count > 0L;
    }

    @Override
    public List<SysMenu> getTotalMenus() {
        return this.getTotalMenus(null);
    }

    @Override
    public List<SysMenu> getTotalMenus(Set<Long> limitMenuIds) {
        LambdaQueryWrapper menuLambdaQueryWrapper = new LambdaQueryWrapper();
        menuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuId, SysMenu::getMenuName, SysMenu::getMenuParentId, SysMenu::getAppId, SysMenu::getMenuSort});
        if (ObjectUtil.isNotEmpty(limitMenuIds)) {
            menuLambdaQueryWrapper.in(SysMenu::getMenuId, limitMenuIds);
        }
        menuLambdaQueryWrapper.orderByAsc(SysMenu::getMenuSort);
        List list = this.list((Wrapper)menuLambdaQueryWrapper);
        MenuOrderFixUtil.fixOrder(list);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMenuTree(SysMenuRequest sysMenuRequest) {
        List<SysMenu> updateTree = sysMenuRequest.getUpdateMenuTree();
        MenuTreeFactory.updateSort(updateTree, 1);
        MenuTreeFactory.fillParentId(-1L, updateTree);
        ArrayList<SysMenu> totalMenuList = new ArrayList<SysMenu>();
        MenuTreeFactory.collectTreeTasks(updateTree, totalMenuList);
        PidStructureBuildUtil.createPidStructure(totalMenuList);
        this.updateBatchById(totalMenuList);
    }

    @Override
    public List<SysMenu> getTotalMenuList() {
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuId, SysMenu::getAppId});
        return this.list((Wrapper)sysMenuLambdaQueryWrapper);
    }

    @Override
    public List<SysMenu> getIndexMenuInfoList(List<Long> menuIdList) {
        if (ObjectUtil.isEmpty(menuIdList)) {
            return new ArrayList<SysMenu>();
        }
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.in(SysMenu::getMenuId, menuIdList);
        sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuId, SysMenu::getMenuParentId, SysMenu::getMenuPids, SysMenu::getAppId, SysMenu::getMenuCode, SysMenu::getMenuName, SysMenu::getMenuType, SysMenu::getAntdvIcon, SysMenu::getAntdvVisible, SysMenu::getAntdvActiveUrl, SysMenu::getAntdvRouter, SysMenu::getAntdvComponent, SysMenu::getMenuSort, SysMenu::getAppDesignBusinessId});
        sysMenuLambdaQueryWrapper.orderByAsc(SysMenu::getMenuSort);
        return this.list((Wrapper)sysMenuLambdaQueryWrapper);
    }

    @Override
    public List<String> getMenuCodeList(List<Long> menuIdList) {
        ArrayList<String> result = new ArrayList<String>();
        if (ObjectUtil.isEmpty(menuIdList)) {
            return result;
        }
        for (Long menuId : menuIdList) {
            String menuCodeQueryResult;
            String menuIdKey = menuId.toString();
            String menuCode = (String)this.menuCodeCache.get(menuIdKey);
            if (ObjectUtil.isNotEmpty((Object)menuCode)) {
                result.add(menuCode);
                continue;
            }
            LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
            sysMenuLambdaQueryWrapper.eq(SysMenu::getMenuId, (Object)menuId);
            sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuCode});
            SysMenu sysMenu = (SysMenu)((Object)this.getOne((Wrapper)sysMenuLambdaQueryWrapper, false));
            if (sysMenu == null || !ObjectUtil.isNotEmpty((Object)(menuCodeQueryResult = sysMenu.getMenuCode()))) continue;
            result.add(menuCodeQueryResult);
            this.menuCodeCache.put(menuIdKey, (Object)menuCodeQueryResult, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return result;
    }

    @Override
    public List<AppGroupDetail> getAppMenuGroupDetail(SysMenuRequest sysMenuRequest) {
        Set<Long> menuParentIds;
        List<AppGroupDetail> appList = this.sysAppService.getAppList();
        if (ObjectUtil.isEmpty(appList)) {
            return new ArrayList<AppGroupDetail>();
        }
        Set totalAppIds = appList.stream().map(AppGroupDetail::getAppId).collect(Collectors.toSet());
        LambdaQueryWrapper<SysMenu> wrapper = this.createWrapper(sysMenuRequest);
        wrapper.in(SysMenu::getAppId, totalAppIds);
        wrapper.select(new SFunction[]{SysMenu::getMenuId, SysMenu::getMenuParentId, SysMenu::getMenuPids, SysMenu::getMenuName, SysMenu::getAppId, SysMenu::getMenuType});
        List sysMenuList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)sysMenuList)) {
            return appList;
        }
        if (StrUtil.isNotBlank((CharSequence)sysMenuRequest.getSearchText()) && ObjectUtil.isNotEmpty(menuParentIds = MenuFactory.getMenuParentIds(sysMenuList))) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysMenu::getMenuId, menuParentIds);
            queryWrapper.select(new SFunction[]{SysMenu::getMenuId, SysMenu::getMenuParentId, SysMenu::getMenuPids, SysMenu::getMenuName, SysMenu::getAppId, SysMenu::getMenuType});
            queryWrapper.orderByAsc(SysMenu::getMenuSort);
            List parentMenus = this.list((Wrapper)queryWrapper);
            sysMenuList.addAll(parentMenus);
        }
        return MenuFactory.createAppGroupDetailResult(appList, sysMenuList);
    }

    public List<UserAppMenuInfo> getUserAppMenuDetailList(Set<Long> menuIdList) {
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.in(SysMenu::getMenuId, menuIdList);
        sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuId, SysMenu::getMenuName, SysMenu::getAntdvRouter, SysMenu::getAntdvIcon});
        List sysMenuList = this.list((Wrapper)sysMenuLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)sysMenuList)) {
            return new ArrayList<UserAppMenuInfo>();
        }
        ArrayList<UserAppMenuInfo> result = new ArrayList<UserAppMenuInfo>();
        for (SysMenu sysMenu : sysMenuList) {
            UserAppMenuInfo userAppMenuInfo = new UserAppMenuInfo();
            userAppMenuInfo.setMenuId(sysMenu.getMenuId());
            userAppMenuInfo.setMenuName(sysMenu.getMenuName());
            userAppMenuInfo.setMenuIcon(sysMenu.getAntdvIcon());
            userAppMenuInfo.setMenuRouter(sysMenu.getAntdvRouter());
            result.add(userAppMenuInfo);
        }
        return result;
    }

    public Map<Long, Long> getMenuAppId(List<Long> menuIdList) {
        HashMap<Long, Long> menuIdAppIdMap = new HashMap<Long, Long>();
        if (ObjectUtil.isEmpty(menuIdList)) {
            return menuIdAppIdMap;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMenu::getMenuId, menuIdList);
        queryWrapper.select(new SFunction[]{SysMenu::getAppId, SysMenu::getMenuId});
        List queryList = this.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)queryList)) {
            return menuIdAppIdMap;
        }
        for (SysMenu sysMenu : queryList) {
            menuIdAppIdMap.put(sysMenu.getMenuId(), sysMenu.getAppId());
        }
        return menuIdAppIdMap;
    }

    private SysMenu querySysMenu(SysMenuRequest sysMenuRequest) {
        SysMenu sysMenu = (SysMenu)((Object)this.getById(sysMenuRequest.getMenuId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysMenu))) {
            throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.SYS_MENU_NOT_EXISTED);
        }
        return sysMenu;
    }

    private LambdaQueryWrapper<SysMenu> createWrapper(SysMenuRequest sysMenuRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysMenuRequest.getSearchText();
        if (StrUtil.isNotBlank((CharSequence)searchText)) {
            queryWrapper.like(SysMenu::getMenuName, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysMenu::getMenuCode, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysMenu::getAntdvRouter, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysMenu::getAntdvComponent, (Object)searchText);
        }
        queryWrapper.orderByAsc(SysMenu::getMenuSort);
        return queryWrapper;
    }

    private String createPids(Long pid) {
        if (pid.equals(TreeConstants.DEFAULT_PARENT_ID)) {
            return "[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",";
        }
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.eq(SysMenu::getMenuId, (Object)pid);
        sysMenuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuPids});
        SysMenu parentMenu = (SysMenu)((Object)this.getOne((Wrapper)sysMenuLambdaQueryWrapper, false));
        if (parentMenu == null) {
            return "[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",";
        }
        return parentMenu.getMenuPids() + "[" + pid + "]" + ",";
    }
}

