/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.resource.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.context.DbOperatorContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.constants.RuleConstants;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceUrlParam;
import cn.stylefeng.roses.kernel.sys.modular.resource.entity.SysResource;
import cn.stylefeng.roses.kernel.sys.modular.resource.mapper.SysResourceMapper;
import cn.stylefeng.roses.kernel.sys.modular.resource.pojo.ResourceRequest;
import cn.stylefeng.roses.kernel.sys.modular.resource.pojo.ResourceTreeNode;
import cn.stylefeng.roses.kernel.sys.modular.resource.service.SysResourceService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SysResourceServiceImpl
extends ServiceImpl<SysResourceMapper, SysResource>
implements SysResourceService {
    private static final Logger log = LoggerFactory.getLogger(SysResourceServiceImpl.class);
    @Resource(name="resourceCache")
    private CacheOperatorApi<ResourceDefinition> resourceCache;

    @Override
    public PageResult<SysResource> findPage(ResourceRequest resourceRequest) {
        LambdaQueryWrapper<SysResource> wrapper = this.createWrapper(resourceRequest);
        wrapper.select(new SFunction[]{SysResource::getResourceName, SysResource::getUrl, SysResource::getClassName, SysResource::getHttpMethod, SysResource::getRequiredLoginFlag, SysResource::getRequiredPermissionFlag, SysResource::getIpAddress, BaseEntity::getCreateTime});
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public void deleteResourceByProjectCode(String projectCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysResource::getProjectCode, (Object)projectCode);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void batchSaveResourceList(List<SysResource> sysResourceList) {
        DbTypeEnum currentDbType = DbOperatorContext.me().getCurrentDbType();
        if (DbTypeEnum.MYSQL.equals((Object)currentDbType)) {
            List split = ListUtil.split(sysResourceList, (int)100);
            for (List sysResources : split) {
                ((SysResourceMapper)this.getBaseMapper()).insertBatchSomeColumn(sysResources);
            }
        } else {
            this.saveBatch(sysResourceList, sysResourceList.size());
        }
    }

    @Override
    public List<ResourceTreeNode> getResourceList(List<String> resourceCodes, Boolean treeBuildFlag, Integer resourceBizType) {
        ArrayList<ResourceTreeNode> res = new ArrayList<ResourceTreeNode>();
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.select(new SFunction[]{SysResource::getAppCode, SysResource::getModularCode, SysResource::getModularName, SysResource::getResourceCode, SysResource::getUrl, SysResource::getResourceName});
        sysResourceLambdaQueryWrapper.eq(SysResource::getRequiredPermissionFlag, (Object)YesOrNotEnum.Y.getCode());
        sysResourceLambdaQueryWrapper.eq(ObjectUtil.isNotEmpty((Object)resourceBizType), SysResource::getResourceBizType, (Object)resourceBizType);
        List allResource = this.list((Wrapper)sysResourceLambdaQueryWrapper);
        HashMap<String, ArrayList<SysResource>> modularMap = new HashMap<String, ArrayList<SysResource>>();
        for (SysResource sysResource : allResource) {
            ArrayList<SysResource> sysResources = (ArrayList<SysResource>)modularMap.get(sysResource.getModularName());
            if (ObjectUtil.isEmpty((Object)sysResources)) {
                sysResources = new ArrayList<SysResource>();
                modularMap.put(sysResource.getModularName(), sysResources);
            }
            sysResources.add(sysResource);
        }
        for (Map.Entry entry : modularMap.entrySet()) {
            ResourceTreeNode item = new ResourceTreeNode();
            item.setResourceFlag(false);
            String id = IdWorker.get32UUID();
            item.setCode(id);
            item.setParentCode(RuleConstants.TREE_ROOT_ID.toString());
            item.setNodeName((String)entry.getKey());
            int checkedNumber = 0;
            for (SysResource resource : (List)entry.getValue()) {
                ResourceTreeNode subItem = new ResourceTreeNode();
                if (!resourceCodes.contains(resource.getResourceCode())) {
                    subItem.setChecked(false);
                } else {
                    ++checkedNumber;
                    item.setChecked(true);
                    subItem.setChecked(true);
                }
                subItem.setResourceFlag(true);
                subItem.setNodeName(resource.getResourceName());
                subItem.setCode(resource.getResourceCode());
                subItem.setParentCode(id);
                res.add(subItem);
            }
            if (checkedNumber == 0) {
                item.setChecked(false);
                item.setIndeterminate(false);
            } else if (checkedNumber == ((List)entry.getValue()).size()) {
                item.setChecked(true);
                item.setIndeterminate(false);
            } else {
                item.setChecked(false);
                item.setIndeterminate(true);
            }
            res.add(item);
        }
        if (treeBuildFlag.booleanValue()) {
            return new DefaultTreeBuildFactory().doTreeBuild(res);
        }
        return res;
    }

    public ResourceDefinition getResourceByUrl(ResourceUrlParam resourceUrlReq) {
        if (ObjectUtil.isEmpty((Object)resourceUrlReq.getUrl()) || ObjectUtil.isEmpty((Object)resourceUrlReq.getUrl())) {
            return null;
        }
        ResourceDefinition tempCachedResourceDefinition = (ResourceDefinition)this.resourceCache.get(resourceUrlReq.getUrl());
        if (tempCachedResourceDefinition != null) {
            return tempCachedResourceDefinition;
        }
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.eq(SysResource::getUrl, (Object)resourceUrlReq.getUrl());
        List resources = this.list((Wrapper)sysResourceLambdaQueryWrapper);
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        SysResource resource = (SysResource)((Object)resources.get(0));
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        BeanUtils.copyProperties((Object)((Object)resource), (Object)resourceDefinition);
        String requiredLoginFlag = resource.getRequiredLoginFlag();
        resourceDefinition.setRequiredLoginFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(requiredLoginFlag)));
        String requiredPermissionFlag = resource.getRequiredPermissionFlag();
        resourceDefinition.setRequiredPermissionFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(requiredPermissionFlag)));
        this.resourceCache.put(resourceDefinition.getUrl(), (Object)resourceDefinition);
        return resourceDefinition;
    }

    public Set<String> getResourceUrlsListByCodes(Set<String> resourceCodes) {
        if (resourceCodes == null || resourceCodes.isEmpty()) {
            return new HashSet<String>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysResource::getResourceCode, resourceCodes);
        queryWrapper.select(new SFunction[]{SysResource::getUrl});
        List list = this.list((Wrapper)queryWrapper);
        return list.stream().map(SysResource::getUrl).collect(Collectors.toSet());
    }

    private LambdaQueryWrapper<SysResource> createWrapper(ResourceRequest resourceRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isEmpty((Object)((Object)resourceRequest))) {
            return queryWrapper;
        }
        String searchText = resourceRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.like(SysResource::getResourceName, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysResource::getResourceCode, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysResource::getUrl, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysResource::getClassName, (Object)searchText);
        }
        return queryWrapper;
    }
}

