/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.factory;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.sys.modular.app.entity.SysApp;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.PermissionNodeTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindPermissionItem;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindPermissionResponse;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PermissionAssignFactory {
    public static List<RoleBindPermissionItem> createPermissionMenus(List<SysMenu> sysMenus) {
        if (ObjectUtil.isEmpty(sysMenus)) {
            return new ArrayList<RoleBindPermissionItem>();
        }
        Set totalParentMenuId = sysMenus.stream().map(SysMenu::getMenuParentId).collect(Collectors.toSet());
        Set leafMenus = sysMenus.stream().filter(item -> !totalParentMenuId.contains(item.getMenuId())).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList<RoleBindPermissionItem> roleBindPermissionItems = new ArrayList<RoleBindPermissionItem>();
        for (SysMenu leafMenu : leafMenus) {
            RoleBindPermissionItem roleBindPermissionItem = new RoleBindPermissionItem(leafMenu.getMenuId(), leafMenu.getAppId(), leafMenu.getMenuName(), PermissionNodeTypeEnum.MENU.getCode(), false);
            roleBindPermissionItems.add(roleBindPermissionItem);
        }
        return roleBindPermissionItems;
    }

    public static List<RoleBindPermissionItem> createApps(List<SysApp> sysApps) {
        if (ObjectUtil.isEmpty(sysApps)) {
            return new ArrayList<RoleBindPermissionItem>();
        }
        ArrayList<RoleBindPermissionItem> appResults = new ArrayList<RoleBindPermissionItem>();
        for (SysApp sysApp : sysApps) {
            RoleBindPermissionItem roleBindPermissionItem = new RoleBindPermissionItem(sysApp.getAppId(), TreeConstants.DEFAULT_PARENT_ID, sysApp.getAppName(), PermissionNodeTypeEnum.APP.getCode(), false);
            appResults.add(roleBindPermissionItem);
        }
        return appResults;
    }

    public static List<RoleBindPermissionItem> createMenuOptions(List<SysMenuOptions> sysMenuOptionsList) {
        if (ObjectUtil.isEmpty(sysMenuOptionsList)) {
            return new ArrayList<RoleBindPermissionItem>();
        }
        ArrayList<RoleBindPermissionItem> optionsResult = new ArrayList<RoleBindPermissionItem>();
        for (SysMenuOptions sysMenuOptions : sysMenuOptionsList) {
            RoleBindPermissionItem roleBindPermissionItem = new RoleBindPermissionItem(sysMenuOptions.getMenuOptionId(), sysMenuOptions.getMenuId(), sysMenuOptions.getOptionName(), PermissionNodeTypeEnum.OPTIONS.getCode(), false);
            optionsResult.add(roleBindPermissionItem);
        }
        return optionsResult;
    }

    public static RoleBindPermissionResponse composeSelectStructure(List<RoleBindPermissionItem> apps, List<RoleBindPermissionItem> menus, List<RoleBindPermissionItem> options) {
        RoleBindPermissionResponse roleBindPermissionResponse = new RoleBindPermissionResponse();
        roleBindPermissionResponse.setChecked(false);
        apps.addAll(menus);
        apps.addAll(options);
        List roleBindPermissionItems = new DefaultTreeBuildFactory().doTreeBuild(apps);
        roleBindPermissionResponse.setAppPermissionList(roleBindPermissionItems);
        return roleBindPermissionResponse;
    }

    public static RoleBindPermissionResponse fillCheckedFlag(RoleBindPermissionResponse roleBindPermissionResponse, Set<Long> rolePermissions) {
        List<RoleBindPermissionItem> appList = roleBindPermissionResponse.getAppPermissionList();
        PermissionAssignFactory.fillSubItemCheckedFlag(appList, rolePermissions);
        for (RoleBindPermissionItem appItem : appList) {
            PermissionAssignFactory.fillParentCheckedFlag(appItem);
        }
        roleBindPermissionResponse.setChecked(true);
        for (RoleBindPermissionItem appItem : appList) {
            if (appItem.getChecked().booleanValue()) continue;
            roleBindPermissionResponse.setChecked(false);
        }
        return roleBindPermissionResponse;
    }

    private static void fillSubItemCheckedFlag(List<RoleBindPermissionItem> beFilled, Set<Long> rolePermissionList) {
        if (ObjectUtil.isEmpty(beFilled) || ObjectUtil.isEmpty(rolePermissionList)) {
            return;
        }
        for (RoleBindPermissionItem roleBindPermissionItem : beFilled) {
            if (rolePermissionList.contains(Convert.toLong((Object)roleBindPermissionItem.getNodeId()))) {
                roleBindPermissionItem.setChecked(true);
            }
            PermissionAssignFactory.fillSubItemCheckedFlag(roleBindPermissionItem.getChildren(), rolePermissionList);
        }
    }

    private static void fillParentCheckedFlag(RoleBindPermissionItem appItem) {
        if (ObjectUtil.isEmpty((Object)appItem)) {
            return;
        }
        appItem.setChecked(true);
        for (RoleBindPermissionItem menuItem : appItem.getChildren()) {
            if (!menuItem.getChecked().booleanValue()) {
                appItem.setChecked(false);
            }
            for (RoleBindPermissionItem options : menuItem.getChildren()) {
                if (options.getChecked().booleanValue()) continue;
                appItem.setChecked(false);
            }
        }
    }
}

