/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleAssignOperateAction;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleBindLimitAction;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleLimit;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.PermissionNodeTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.RoleLimitTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleLimitService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.util.AssertAssignUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RoleBindTotalImpl
implements RoleAssignOperateAction,
RoleBindLimitAction {
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysRoleLimitService sysRoleLimitService;

    @Override
    public PermissionNodeTypeEnum getNodeType() {
        return PermissionNodeTypeEnum.TOTAL;
    }

    @Override
    public void doOperateAction(RoleBindPermissionRequest roleBindPermissionRequest, Set<Long> roleLimitMenuIdsAndOptionIds) {
        Long roleId = roleBindPermissionRequest.getRoleId();
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getRoleId, (Object)roleId);
        this.sysRoleMenuService.remove((Wrapper)sysRoleMenuLambdaQueryWrapper);
        LambdaQueryWrapper sysRoleMenuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuOptionsLambdaQueryWrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
        AssertAssignUtil.assertAssign(roleId, (LambdaQueryWrapper<SysRoleMenuOptions>)sysRoleMenuOptionsLambdaQueryWrapper);
        this.sysRoleMenuOptionsService.remove((Wrapper)sysRoleMenuOptionsLambdaQueryWrapper);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            List<SysMenu> totalMenus = this.sysMenuService.getTotalMenus(roleLimitMenuIdsAndOptionIds);
            ArrayList<SysRoleMenu> sysRoleMenuList = new ArrayList<SysRoleMenu>();
            for (SysMenu menuItem : totalMenus) {
                SysRoleMenu sysRoleMenu = new SysRoleMenu();
                sysRoleMenu.setRoleId(roleId);
                sysRoleMenu.setAppId(menuItem.getAppId());
                sysRoleMenu.setMenuId(menuItem.getMenuId());
                sysRoleMenuList.add(sysRoleMenu);
            }
            this.sysRoleMenuService.saveBatch(sysRoleMenuList);
            List<SysMenuOptions> sysMenuOptionsList = this.sysMenuOptionsService.getTotalMenuOptionsList(roleLimitMenuIdsAndOptionIds);
            ArrayList<SysRoleMenuOptions> sysRoleMenuOptionsList = new ArrayList<SysRoleMenuOptions>();
            for (SysMenuOptions menuOptionItem : sysMenuOptionsList) {
                SysRoleMenuOptions sysRoleMenuOptions = new SysRoleMenuOptions();
                sysRoleMenuOptions.setRoleId(roleId);
                sysRoleMenuOptions.setAppId(menuOptionItem.getAppId());
                sysRoleMenuOptions.setMenuId(menuOptionItem.getMenuId());
                sysRoleMenuOptions.setMenuOptionId(menuOptionItem.getMenuOptionId());
                sysRoleMenuOptionsList.add(sysRoleMenuOptions);
            }
            this.sysRoleMenuOptionsService.saveBatch(sysRoleMenuOptionsList);
        }
    }

    @Override
    public PermissionNodeTypeEnum getRoleBindLimitNodeType() {
        return this.getNodeType();
    }

    @Override
    public void doRoleBindLimitAction(RoleBindPermissionRequest roleBindPermissionRequest) {
        Long roleId = roleBindPermissionRequest.getRoleId();
        LambdaQueryWrapper sysRoleLimitLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLimitLambdaQueryWrapper.eq(SysRoleLimit::getRoleId, (Object)roleId);
        this.sysRoleLimitService.remove((Wrapper)sysRoleLimitLambdaQueryWrapper);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            List<SysMenu> totalMenus = this.sysMenuService.getTotalMenus();
            ArrayList<SysRoleLimit> sysRoleLimitList = new ArrayList<SysRoleLimit>();
            for (SysMenu menuItem : totalMenus) {
                SysRoleLimit sysRoleLimit = new SysRoleLimit();
                sysRoleLimit.setRoleId(roleId);
                sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU.getCode());
                sysRoleLimit.setBusinessId(menuItem.getMenuId());
                sysRoleLimitList.add(sysRoleLimit);
            }
            List<SysMenuOptions> sysMenuOptionsList = this.sysMenuOptionsService.getTotalMenuOptionsList();
            for (SysMenuOptions menuOptionItem : sysMenuOptionsList) {
                SysRoleLimit sysRoleLimit = new SysRoleLimit();
                sysRoleLimit.setRoleId(roleId);
                sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU_OPTIONS.getCode());
                sysRoleLimit.setBusinessId(menuOptionItem.getMenuOptionId());
                sysRoleLimitList.add(sysRoleLimit);
            }
            this.sysRoleLimitService.saveBatch(sysRoleLimitList);
        }
    }
}

