/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.security.service.impl;

import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.expander.LoginConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.config.api.ConfigServiceApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.SecurityConfigService;
import cn.stylefeng.roses.kernel.sys.api.exception.SysException;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.SecurityStrategyExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.security.SecurityConfig;
import cn.stylefeng.roses.kernel.sys.modular.security.entity.SysUserPasswordRecord;
import cn.stylefeng.roses.kernel.sys.modular.security.service.SysUserPasswordRecordService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SecurityConfigServiceImpl
implements SecurityConfigService {
    @Resource
    private ConfigServiceApi configServiceApi;
    @Resource
    private SysUserPasswordRecordService sysUserPasswordRecordService;
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;

    public SecurityConfig getSecurityConfig() {
        SecurityConfig securityConfig = new SecurityConfig();
        securityConfig.setMaxErrorLoginCount(LoginConfigExpander.getMaxErrorLoginCount());
        securityConfig.setMinPasswordLength(LoginConfigExpander.getMinPasswordLength());
        securityConfig.setPasswordMinSpecialSymbolCount(LoginConfigExpander.getPasswordMinSpecialSymbolCount());
        securityConfig.setGetPasswordMinUpperCaseCount(LoginConfigExpander.getPasswordMinUpperCaseCount());
        securityConfig.setPasswordMinLowerCaseCount(LoginConfigExpander.getPasswordMinLowerCaseCount());
        securityConfig.setPasswordMinNumberCount(LoginConfigExpander.getPasswordMinNumberCount());
        securityConfig.setPasswordMinUpdateDays(LoginConfigExpander.getPasswordMinUpdateDays());
        securityConfig.setPasswordMinCantRepeatTimes(LoginConfigExpander.getPasswordMinCantRepeatTimes());
        return securityConfig;
    }

    public void updateSecurityConfig(SecurityConfig securityConfig) {
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_MAX_ERROR_LOGIN_COUNT", String.valueOf(securityConfig.getMaxErrorLoginCount()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_MIN_PASSWORD_LENGTH", String.valueOf(securityConfig.getMinPasswordLength()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_PASSWORD_MIN_SPECIAL_SYMBOL_COUNT", String.valueOf(securityConfig.getPasswordMinSpecialSymbolCount()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_PASSWORD_MIN_UPPER_CASE_COUNT", String.valueOf(securityConfig.getGetPasswordMinUpperCaseCount()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_PASSWORD_MIN_LOWER_CASE_COUNT", String.valueOf(securityConfig.getPasswordMinLowerCaseCount()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_PASSWORD_MIN_NUMBER_COUNT", String.valueOf(securityConfig.getPasswordMinNumberCount()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_PASSWORD_MIN_UPDATE_DAYS", String.valueOf(securityConfig.getPasswordMinUpdateDays()));
        this.configServiceApi.updateConfigByCode("SYS_LOGIN_PASSWORD_MIN_CANT_REPEAT_TIMES", String.valueOf(securityConfig.getPasswordMinCantRepeatTimes()));
    }

    public void validatePasswordSecurityRule(boolean updatePasswordFlag, String password) {
        SecurityConfig securityConfig = this.getSecurityConfig();
        if (password.length() < securityConfig.getMinPasswordLength()) {
            throw new SysException((AbstractExceptionEnum)SecurityStrategyExceptionEnum.PASSWORD_LENGTH, new Object[]{securityConfig.getMinPasswordLength()});
        }
        int specialSymbolCount = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            ++specialSymbolCount;
        }
        if (specialSymbolCount < securityConfig.getPasswordMinSpecialSymbolCount()) {
            throw new SysException((AbstractExceptionEnum)SecurityStrategyExceptionEnum.SPECIAL_SYMBOL, new Object[]{securityConfig.getPasswordMinSpecialSymbolCount()});
        }
        int upperCaseCount = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            ++upperCaseCount;
        }
        if (upperCaseCount < securityConfig.getGetPasswordMinUpperCaseCount()) {
            throw new SysException((AbstractExceptionEnum)SecurityStrategyExceptionEnum.UPPER_CASE, new Object[]{securityConfig.getGetPasswordMinUpperCaseCount()});
        }
        int lowerCaseCount = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            ++lowerCaseCount;
        }
        if (lowerCaseCount < securityConfig.getPasswordMinLowerCaseCount()) {
            throw new SysException((AbstractExceptionEnum)SecurityStrategyExceptionEnum.LOWER_CASE, new Object[]{securityConfig.getPasswordMinLowerCaseCount()});
        }
        int numberCount = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (!Character.isDigit(c)) continue;
            ++numberCount;
        }
        if (numberCount < securityConfig.getPasswordMinNumberCount()) {
            throw new SysException((AbstractExceptionEnum)SecurityStrategyExceptionEnum.NUMBER_SYMBOL, new Object[]{securityConfig.getPasswordMinNumberCount()});
        }
        Integer passwordMinCantRepeatTimes = securityConfig.getPasswordMinCantRepeatTimes();
        if (passwordMinCantRepeatTimes == null || passwordMinCantRepeatTimes.equals(0)) {
            return;
        }
        List<SysUserPasswordRecord> recentRecords = this.sysUserPasswordRecordService.getRecentRecords(LoginContext.me().getLoginUser().getUserId(), passwordMinCantRepeatTimes);
        for (SysUserPasswordRecord recentRecord : recentRecords) {
            Boolean resultTrue = this.passwordStoredEncryptApi.checkPasswordWithSalt(password, recentRecord.getHistoryPasswordSalt(), recentRecord.getHistoryPassword());
            if (!resultTrue.booleanValue()) continue;
            throw new SysException((AbstractExceptionEnum)SecurityStrategyExceptionEnum.PASSWORD_REPEAT, new Object[]{passwordMinCantRepeatTimes});
        }
    }

    public void recordPasswordEditLog(Long userId, String md5, String salt) {
        SysUserPasswordRecord sysUserPasswordRecord = new SysUserPasswordRecord();
        sysUserPasswordRecord.setUserId(userId);
        sysUserPasswordRecord.setHistoryPassword(md5);
        sysUserPasswordRecord.setHistoryPasswordSalt(salt);
        sysUserPasswordRecord.setUpdatePasswordTime(new Date());
        this.sysUserPasswordRecordService.save((Object)sysUserPasswordRecord);
    }
}

