/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.http;

import cn.ucloud.common.handler.UcloudHandler;
import cn.ucloud.common.http.Http;
import cn.ucloud.common.http.UcloudHttp;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.BaseResponseResult;
import cn.ucloud.common.pojo.UcloudConfig;
import cn.ucloud.common.util.ParamConstructor;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcloudHttpImpl
implements UcloudHttp {
    private Class<? extends BaseResponseResult> resultClass;
    private static Logger logger = LoggerFactory.getLogger((String)UcloudHttpImpl.class.getName());

    public UcloudHttpImpl(Class<? extends BaseResponseResult> resultClass) {
        this.resultClass = resultClass;
    }

    @Override
    public Object doGet(BaseRequestParam param, UcloudConfig config, UcloudHandler handler, Boolean ... asyncFlag) throws Exception {
        BaseResponseResult result = null;
        try {
            String httpGetParamString = ParamConstructor.getHttpGetParamString(param, config.getAccount());
            HttpGet get = new HttpGet(config.getApiServerAddr() + "?" + httpGetParamString);
            Http http = new Http(this.resultClass);
            result = http.doHttp((HttpUriRequest)get, handler, this.async(asyncFlag));
        }
        catch (Exception e) {
            this.handlerException(handler, e, this.async(asyncFlag));
        }
        return result;
    }

    @Override
    public Object doPost(BaseRequestParam param, UcloudConfig config, UcloudHandler handler, Boolean ... asyncFlag) throws Exception {
        BaseResponseResult result = null;
        try {
            String httpPostParamString = ParamConstructor.getHttpPostParamString(param, config.getAccount());
            HttpPost post = new HttpPost(config.getApiServerAddr());
            post.setHeader("Content-Type", "application/json");
            StringEntity entity = new StringEntity(httpPostParamString, StandardCharsets.UTF_8);
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            Http http = new Http(this.resultClass);
            result = http.doHttp((HttpUriRequest)post, handler, this.async(asyncFlag));
        }
        catch (Exception e) {
            this.handlerException(handler, e, this.async(asyncFlag));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlerException(UcloudHandler handler, Exception e, Boolean async) throws Exception {
        if (handler == null) {
            if (async == null) throw e;
            logger.error("handler is null and async is not null,but get an error:{}", (Object)e.getMessage());
            return;
        } else {
            handler.error(e);
        }
    }

    private Boolean async(Boolean ... asyncFlag) {
        Boolean async = null;
        if (asyncFlag != null && asyncFlag.length > 0) {
            async = asyncFlag[0];
        }
        return async;
    }
}

