/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.http;

import cn.ucloud.common.handler.UcloudHandler;
import cn.ucloud.common.http.Http;
import cn.ucloud.common.http.UcloudRestHttp;
import cn.ucloud.common.pojo.BaseResponseResult;
import cn.ucloud.common.pojo.BaseRestRequestParam;
import cn.ucloud.common.pojo.UcloudConfig;
import cn.ucloud.common.util.RestParamConstructor;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcloudRestHttpImpl
implements UcloudRestHttp {
    private Class<? extends BaseResponseResult> resultClass;
    private static Logger logger = LoggerFactory.getLogger((String)UcloudRestHttpImpl.class.getName());

    public UcloudRestHttpImpl(Class<? extends BaseResponseResult> resultClass) {
        this.resultClass = resultClass;
    }

    @Override
    public Object doGet(BaseRestRequestParam param, UcloudConfig config, String restURL, UcloudHandler handler, Boolean ... asyncFlag) throws Exception {
        BaseResponseResult result = null;
        try {
            RestParamConstructor constructor = new RestParamConstructor(config.getAccount(), param);
            List<Header> headerList = constructor.getHeaders();
            Header[] headers = new Header[headerList.size()];
            headers = headerList.toArray(headers);
            String restHttpURLParamString = constructor.getRestHttpURLParamString();
            HttpGet get = new HttpGet(String.format("%s?%s", restURL, restHttpURLParamString));
            get.setHeaders(headers);
            Http http = new Http(this.resultClass);
            result = http.doHttp((HttpUriRequest)get, handler, this.async(asyncFlag));
        }
        catch (Exception e) {
            this.handlerException(handler, e, this.async(asyncFlag));
        }
        return result;
    }

    @Override
    public Object doPost(BaseRestRequestParam param, UcloudConfig config, String restURL, UcloudHandler handler, Boolean ... asyncFlag) throws Exception {
        BaseResponseResult result = null;
        try {
            HttpPost post = new HttpPost(restURL);
            RestParamConstructor constructor = new RestParamConstructor(config.getAccount(), param);
            List<Header> headerList = constructor.getHeaders();
            Header[] headers = new Header[headerList.size()];
            headers = headerList.toArray(headers);
            HttpEntity entity = constructor.getEntity();
            post.setEntity(entity);
            post.setHeaders(headers);
            Http http = new Http(this.resultClass);
            result = http.doHttp((HttpUriRequest)post, handler, this.async(asyncFlag));
        }
        catch (Exception e) {
            this.handlerException(handler, e, this.async(asyncFlag));
        }
        return result;
    }

    private Boolean async(Boolean ... asyncFlag) {
        Boolean async = null;
        if (asyncFlag != null && asyncFlag.length > 0) {
            async = asyncFlag[0];
        }
        return async;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlerException(UcloudHandler handler, Exception e, Boolean async) throws Exception {
        if (handler == null) {
            if (async == null) throw e;
            logger.error("handler is null and async is not null,but get an error:{}", (Object)e.getMessage());
            return;
        } else {
            handler.error(e);
        }
    }
}

