/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.model;

import cn.ucloud.common.pojo.BaseResponseResult;
import cn.ucloud.common.util.StringEqual;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class GetRegionResult
extends BaseResponseResult {
    @SerializedName(value="Regions")
    private List<RealRegion> realRegions;
    private List<Region> regions;

    public List<Region> getRegions() {
        if (this.regions == null && this.realRegions != null) {
            this.regions = new ArrayList<Region>();
            for (RealRegion realRegion : this.realRegions) {
                boolean regionFlag = false;
                for (Region region : this.regions) {
                    if (!StringEqual.regionZoneStringEqual(region.region, realRegion.region)) continue;
                    regionFlag = true;
                    if (region.zones == null) {
                        region.zones = new ArrayList();
                    }
                    boolean zoneFlag = false;
                    for (String zone : region.zones) {
                        if (!StringEqual.regionZoneStringEqual(zone, realRegion.zone)) continue;
                        zoneFlag = true;
                        break;
                    }
                    if (zoneFlag || realRegion.zone == null || realRegion.zone.length() <= 0) break;
                    region.zones.add(realRegion.zone);
                    break;
                }
                if (regionFlag || realRegion.region == null || realRegion.region.length() <= 0) continue;
                Region region = new Region();
                region.region = realRegion.region;
                region.zones = new ArrayList();
                if (realRegion.zone != null && realRegion.zone.length() > 0) {
                    region.zones.add(realRegion.zone);
                }
                this.regions.add(region);
            }
        }
        return this.regions;
    }

    public void setRegions(List<Region> regions) {
        this.regions = regions;
    }

    private List<RealRegion> getRealRegions() {
        return this.realRegions;
    }

    private void setRealRegions(List<RealRegion> realRegions) {
        this.realRegions = realRegions;
    }

    @Override
    public String toString() {
        return "GetRegionResult{regions=" + this.getRegions() + ", retCode=" + this.retCode + ", action='" + this.action + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public static class Region {
        private String region;
        private List<String> zones;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public List<String> getZones() {
            return this.zones;
        }

        public void setZones(List<String> zones) {
            this.zones = zones;
        }

        public String toString() {
            return "Region{region='" + this.region + '\'' + ", zones=" + this.zones + '}';
        }
    }

    private static class RealRegion {
        @SerializedName(value="Region")
        private String region;
        @SerializedName(value="Zone")
        private String zone;

        private RealRegion() {
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getZone() {
            return this.zone;
        }

        public void setZone(String zone) {
            this.zone = zone;
        }

        public String toString() {
            return "RealRegion{region='" + this.region + '\'' + ", zone='" + this.zone + '\'' + '}';
        }
    }
}

