/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.util;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ObjectToParam {
    public static List<Param> objectToParams(BaseRequestParam baseRequestParam) throws Exception {
        ArrayList<Param> params = new ArrayList<Param>();
        if (baseRequestParam != null) {
            Class<?> objectClass = baseRequestParam.getClass();
            params.addAll(ObjectToParam.getFieldParam(objectClass, baseRequestParam));
            params.addAll(ObjectToParam.getMethodParam(objectClass, baseRequestParam));
            Class<Object> superclass = objectClass.getSuperclass();
            while (!superclass.isAssignableFrom(Object.class)) {
                params.addAll(ObjectToParam.getFieldParam(superclass, baseRequestParam));
                params.addAll(ObjectToParam.getMethodParam(superclass, baseRequestParam));
                superclass = superclass.getSuperclass();
            }
        } else {
            throw new NullPointerException("param object can not be null");
        }
        return params;
    }

    private static List<Param> getFieldParam(Class clazz, BaseRequestParam baseRequestParam) throws Exception {
        ArrayList<Param> list = new ArrayList<Param>();
        if (clazz != null) {
            Field[] declaredFields = clazz.getDeclaredFields();
            int len = clazz.getDeclaredFields().length;
            for (int i = 0; i < len; ++i) {
                UcloudParam annotation = declaredFields[i].getAnnotation(UcloudParam.class);
                if (annotation == null) continue;
                declaredFields[i].setAccessible(true);
                Object value = declaredFields[i].get(baseRequestParam);
                if (value == null) continue;
                Param param = new Param(annotation.value(), value);
                list.add(param);
            }
        }
        return list;
    }

    private static List<Param> getMethodParam(Class clazz, BaseRequestParam baseRequestParam) throws Exception {
        ArrayList<Param> list = new ArrayList<Param>();
        if (clazz != null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            int len = declaredMethods.length;
            for (int i = 0; i < len; ++i) {
                UcloudParam annotation = declaredMethods[i].getAnnotation(UcloudParam.class);
                if (annotation == null) continue;
                declaredMethods[i].setAccessible(true);
                Object invoke = declaredMethods[i].invoke((Object)baseRequestParam, new Object[0]);
                if (!(invoke instanceof List)) continue;
                List params = (List)invoke;
                list.addAll(params);
            }
        }
        return list;
    }
}

