/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.util;

import cn.ucloud.common.pojo.Account;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import cn.ucloud.common.util.ObjectToParam;
import cn.ucloud.common.util.ParamValidator;
import cn.ucloud.common.util.Signature;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ParamConstructor {
    public static String getHttpGetParamString(BaseRequestParam baseRequestParam, Account account) throws Exception {
        baseRequestParam.setPublicKey(account.getPublicKey());
        List<Param> paramList = ObjectToParam.objectToParams(baseRequestParam);
        String signature = Signature.getSignature(paramList, account);
        baseRequestParam.setSignature(signature);
        ParamValidator.validator(baseRequestParam);
        Signature.urlEncodeParams(paramList);
        StringBuilder builder = new StringBuilder();
        for (Param param : paramList) {
            if (StringUtils.isBlank((CharSequence)param.getParamKey())) continue;
            builder.append(param.getParamKey() + "=" + param.getParamValue() + "&");
        }
        builder.append("Signature=" + signature);
        return builder.toString();
    }

    public static String getHttpPostParamString(BaseRequestParam baseRequestParam, Account account) throws Exception {
        baseRequestParam.setPublicKey(account.getPublicKey());
        List<Param> paramList = ObjectToParam.objectToParams(baseRequestParam);
        String signature = Signature.getSignature(paramList, account);
        baseRequestParam.setSignature(signature);
        ParamValidator.validator(baseRequestParam);
        paramList.add(new Param("Signature", signature));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Param param : paramList) {
            builder.append("\"" + param.getParamKey() + "\":\"" + param.getParamValue() + "\",");
        }
        String substring = builder.substring(0, builder.toString().length() - 1);
        substring = substring + "}";
        return substring;
    }
}

