/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.util;

import cn.ucloud.common.annotation.UcloudMethod;
import cn.ucloud.common.annotation.UcloudRestParam;
import cn.ucloud.common.http.HttpContentType;
import cn.ucloud.common.http.HttpMethod;
import cn.ucloud.common.http.ParamLocation;
import cn.ucloud.common.pojo.BaseRestRequestParam;
import cn.ucloud.common.pojo.Param;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class RestParamAnalyzer {
    private BaseRestRequestParam baseRestRequestParam;
    private List<Header> headers;
    private List<Param> pathParams;
    private List<Param> bodyParams;
    private List<Param> urlParams;
    private List<Param> signatureParams;
    private HttpMethod method;
    private HttpContentType contentType;

    public RestParamAnalyzer(BaseRestRequestParam baseRestRequestParam) throws Exception {
        this.baseRestRequestParam = baseRestRequestParam;
        this.analyzeParam();
    }

    private void analyzeParam() throws Exception {
        if (this.baseRestRequestParam == null) {
            return;
        }
        Class<?> clazz = this.baseRestRequestParam.getClass();
        UcloudMethod clazzAnnotation = clazz.getAnnotation(UcloudMethod.class);
        if (clazzAnnotation == null) {
            this.method = HttpMethod.GET;
        } else {
            this.method = clazzAnnotation.method();
            this.contentType = clazzAnnotation.contentType();
        }
        switch (this.method) {
            case GET: 
            case DELETE: {
                this.urlParams = new ArrayList<Param>();
                break;
            }
            case PUT: 
            case POST: {
                this.bodyParams = new ArrayList<Param>();
            }
        }
        this.headers = new ArrayList<Header>();
        this.pathParams = new ArrayList<Param>();
        this.signatureParams = new ArrayList<Param>();
        this.analyzeFieldParam(this.baseRestRequestParam.getClass(), this.baseRestRequestParam);
        this.analyzeFieldParam(this.baseRestRequestParam.getClass().getSuperclass(), this.baseRestRequestParam);
        this.analyzeMethodParam(this.baseRestRequestParam.getClass(), this.baseRestRequestParam);
        this.analyzeMethodParam(this.baseRestRequestParam.getClass().getSuperclass(), this.baseRestRequestParam);
    }

    private void analyzeFieldParam(Class clazz, BaseRestRequestParam baseRestRequestParam) throws Exception {
        if (clazz == null) {
            return;
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        int len = declaredFields.length;
        for (int i = 0; i < len; ++i) {
            UcloudRestParam annotation = declaredFields[i].getAnnotation(UcloudRestParam.class);
            if (annotation == null) continue;
            declaredFields[i].setAccessible(true);
            Object value = declaredFields[i].get(baseRestRequestParam);
            String name = annotation.name();
            ParamLocation location = annotation.location();
            boolean signature = annotation.signature();
            ArrayList<Param> params = new ArrayList<Param>();
            if (value instanceof List) {
                for (Object obj : (List)value) {
                    params.add(new Param(name, obj));
                }
            } else {
                params.add(new Param(name, value));
            }
            switch (location) {
                case URL: {
                    if (this.urlParams == null) break;
                    this.urlParams.addAll(params);
                    break;
                }
                case BODY: {
                    if (this.bodyParams == null) break;
                    this.bodyParams.addAll(params);
                    break;
                }
                case PATH: {
                    if (this.pathParams == null) break;
                    this.pathParams.addAll(params);
                    break;
                }
                case HEADER: {
                    if (this.headers == null || value == null) break;
                    this.headers.add((Header)new BasicHeader(name, value.toString()));
                }
            }
            if (!signature || this.signatureParams == null) continue;
            this.signatureParams.addAll(params);
        }
    }

    private void analyzeMethodParam(Class clazz, BaseRestRequestParam baseRestRequestParam) throws Exception {
        if (clazz == null) {
            return;
        }
        Method[] declaredMethods = clazz.getDeclaredMethods();
        int len = declaredMethods.length;
        for (int i = 0; i < len; ++i) {
            UcloudRestParam annotation = declaredMethods[i].getAnnotation(UcloudRestParam.class);
            if (annotation == null) continue;
            declaredMethods[i].setAccessible(true);
            Object invokeValue = declaredMethods[i].invoke((Object)baseRestRequestParam, new Object[0]);
            ParamLocation location = annotation.location();
            boolean signature = annotation.signature();
            if (!(invokeValue instanceof List)) continue;
            List params = (List)invokeValue;
            switch (location) {
                case URL: {
                    if (this.urlParams == null) break;
                    this.urlParams.addAll(params);
                    break;
                }
                case BODY: {
                    if (this.bodyParams == null) break;
                    this.bodyParams.addAll(params);
                    break;
                }
                case PATH: {
                    if (this.pathParams == null) break;
                    this.pathParams.addAll(params);
                    break;
                }
                case HEADER: {
                    if (this.headers == null) break;
                    for (Param param : params) {
                        if (param.getParamValue() == null) continue;
                        this.headers.add((Header)new BasicHeader(param.getParamKey(), param.getParamValue().toString()));
                    }
                    break;
                }
            }
            if (!signature || this.signatureParams == null) continue;
            this.signatureParams.addAll(params);
        }
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Param> getPathParams() {
        return this.pathParams;
    }

    public List<Param> getBodyParams() {
        return this.bodyParams;
    }

    public List<Param> getUrlParams() {
        return this.urlParams;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Param> getSignatureParams() {
        return this.signatureParams;
    }

    public HttpContentType getContentType() {
        return this.contentType;
    }
}

