/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.util;

import cn.ucloud.common.pojo.Account;
import cn.ucloud.common.pojo.BaseRestRequestParam;
import cn.ucloud.common.pojo.Param;
import cn.ucloud.common.util.ParamValidator;
import cn.ucloud.common.util.RestParamAnalyzer;
import cn.ucloud.common.util.Signature;
import com.google.gson.Gson;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestParamConstructor {
    private static final String CHARSET = "UTF-8";
    private static final String KEY_SIGNATUR = "Signature";
    private static final String KEY_PUBLIC_KEY = "PublicKey";
    private HttpEntity entity;
    private String restHttpURLParamString;
    private List<Header> headers;
    private List<Param> pathParams;
    private Account account;
    private BaseRestRequestParam baseRestRequestParam;
    private RestParamAnalyzer analyzer;
    private String signature;
    private static final Logger logger = LoggerFactory.getLogger(RestParamConstructor.class);

    public RestParamConstructor(Account account, BaseRestRequestParam baseRestRequestParam) throws Exception {
        this.account = account;
        this.baseRestRequestParam = baseRestRequestParam;
        baseRestRequestParam.setPublicKey(account.getPublicKey());
        this.analyzer = new RestParamAnalyzer(baseRestRequestParam);
        this.headers = this.analyzer.getHeaders();
        this.pathParams = this.analyzer.getPathParams();
        switch (this.analyzer.getMethod()) {
            case POST: 
            case PUT: {
                this.buildRestHttpBodyParam();
                break;
            }
            case GET: 
            case DELETE: {
                this.buildRestHttpURLParam();
            }
        }
        this.buildHeaders();
    }

    public String getRestHttpURLParamString() {
        return this.restHttpURLParamString;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Param> getPathParams() {
        return this.pathParams;
    }

    private void buildRestHttpURLParam() throws Exception {
        this.signature = Signature.getSignature(this.analyzer.getSignatureParams(), this.account);
        this.baseRestRequestParam.setSignature(this.signature);
        ParamValidator.validator(this.baseRestRequestParam);
        Signature.urlEncodeParams(this.analyzer.getUrlParams());
        this.baseRestRequestParam.setSignature(this.signature);
        StringBuilder builder = new StringBuilder();
        for (Param param : this.analyzer.getUrlParams()) {
            if (StringUtils.isBlank((CharSequence)param.getParamKey())) continue;
            builder.append(param.getParamKey() + "=" + param.getParamValue() + "&");
        }
        builder.append("Signature=" + this.signature);
        this.restHttpURLParamString = builder.toString();
    }

    private void buildHeaders() {
        this.headers.add((Header)new BasicHeader(KEY_SIGNATUR, this.signature));
    }

    private void buildRestHttpBodyParam() throws Exception {
        this.signature = Signature.getSignature(this.analyzer.getSignatureParams(), this.account);
        this.baseRestRequestParam.setSignature(this.signature);
        ParamValidator.validator(this.baseRestRequestParam);
        switch (this.analyzer.getContentType()) {
            case APPLICATION_URL_ENCODED: {
                this.buildURLEncodedFormData();
                break;
            }
            case MULTIPART_FORM_DATA: {
                this.buildMultiPartFormData();
                break;
            }
            case APPLICATION_JSON: {
                this.buildJSONFormData();
            }
        }
    }

    private void buildURLEncodedFormData() {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        if (this.analyzer.getBodyParams() != null) {
            for (Param param : this.analyzer.getBodyParams()) {
                BasicNameValuePair pair = new BasicNameValuePair(param.getParamKey(), param.getParamValue().toString());
                pairs.add(pair);
            }
        }
        this.entity = new UrlEncodedFormEntity(pairs, Charset.forName(CHARSET));
    }

    private void buildJSONFormData() {
        String json = new Gson().toJson((Object)this.baseRestRequestParam);
        this.entity = new StringEntity(json, CHARSET);
    }

    private void buildMultiPartFormData() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName(CHARSET));
        if (this.analyzer.getBodyParams() != null) {
            for (Param param : this.analyzer.getBodyParams()) {
                if (param.getParamValue() == null) continue;
                if (param.getParamValue() instanceof File) {
                    builder.addBinaryBody(param.getParamKey(), (File)param.getParamValue());
                    continue;
                }
                builder.addTextBody(param.getParamKey(), param.getParamValue().toString());
            }
        }
        builder.addTextBody(KEY_SIGNATUR, this.signature);
        builder.addTextBody(KEY_PUBLIC_KEY, this.account.getPublicKey());
        this.entity = builder.build();
    }
}

