/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.util;

import cn.ucloud.common.pojo.Account;
import cn.ucloud.common.pojo.Param;
import cn.ucloud.common.util.FormatUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature {
    private static Logger logger = LoggerFactory.getLogger((String)Signature.class.getName());

    protected static String getSignature(Param[] params, Account account) {
        String signature = "";
        if (params != null) {
            Signature.sortParams(params);
            String stitchParams = Signature.stitchParams(params);
            stitchParams = stitchParams + account.getPrivateKey();
            signature = Signature.sha1(stitchParams);
        }
        return signature;
    }

    protected static String getSignature(List<Param> params, Account account) {
        String signature = "";
        if (params != null) {
            Signature.sortParams(params);
            String stitchParams = Signature.stitchParams(params);
            stitchParams = stitchParams + account.getPrivateKey();
            signature = Signature.sha1(stitchParams);
        }
        return signature;
    }

    protected static Param[] getParamAfterSignature(Param[] params, Account account) {
        Object[] objects;
        if (params == null) {
            params = new Param[]{};
        }
        if ((objects = Signature.insertElement2Array(params, new Param("signature", Signature.getSignature(params, account)), params.length)) == null) {
            objects = new Param[]{};
        }
        int len = objects.length;
        Param[] newParams = new Param[len];
        for (int i = 0; i < len; ++i) {
            if (!(objects[i] instanceof Param)) continue;
            newParams[i] = (Param)objects[i];
        }
        return newParams;
    }

    protected static List<Param> getParamAfterSignature(List<Param> params, Account account) {
        if (params != null) {
            params.add(new Param("signature", Signature.getSignature(params, account)));
        }
        return params;
    }

    protected static void sortParams(Param[] params) {
        int num = params.length;
        for (int i = 0; i < num; ++i) {
            for (int j = i + 1; j < num; ++j) {
                if (params[i].getParamKey().compareTo(params[j].getParamKey()) <= 0) continue;
                Param param = params[i];
                params[i] = params[j];
                params[j] = param;
            }
        }
    }

    protected static void sortParams(List<Param> params) {
        if (params != null) {
            Collections.sort(params, new Comparator<Param>(){

                @Override
                public int compare(Param p1, Param p2) {
                    return p1.getParamKey().compareTo(p2.getParamKey());
                }
            });
        }
    }

    protected static void urlEncodeParams(Param[] params) {
        if (params != null) {
            int num = params.length;
            for (int i = 0; i < num; ++i) {
                try {
                    params[i].setParamValue(URLEncoder.encode(params[i].getParamValue().toString(), "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    protected static void urlEncodeParams(List<Param> params) {
        if (params != null) {
            for (Param param : params) {
                try {
                    param.setParamValue(URLEncoder.encode(param.getParamValue().toString(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    public static String stitchParams(Param[] params) {
        StringBuilder builder = new StringBuilder();
        if (params != null) {
            int num = params.length;
            for (int i = 0; i < num; ++i) {
                builder.append(params[i].getParamKey());
                builder.append(params[i].getParamValue());
            }
        }
        return builder.toString();
    }

    public static String stitchParams(List<Param> params) {
        StringBuilder builder = new StringBuilder();
        if (params != null) {
            for (Param param : params) {
                if (param.getParamValue() == null) continue;
                builder.append(param.getParamKey());
                builder.append(param.getParamValue());
            }
        }
        return builder.toString();
    }

    public static String sha1(String decrypt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(decrypt.getBytes());
            byte[] messageDigest = digest.digest();
            return FormatUtil.formatBytes2HexString(messageDigest, false);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    private static Object[] insertElement2Array(Object[] objects, Object element, int index) {
        Object[] newObjs = null;
        if (objects != null) {
            if (objects[0].getClass().equals(element.getClass())) {
                int len = objects.length;
                newObjs = new Object[len + 1];
                System.arraycopy(objects, 0, newObjs, 0, index);
                newObjs[index] = element;
                System.arraycopy(objects, index, newObjs, index, len - index);
            }
        } else {
            newObjs = new Object[]{element};
        }
        return newObjs;
    }
}

