/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.usms.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import cn.ucloud.usms.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class CreateUSMSSignatureParam
extends BaseRequestParam {
    @NotEmpty(message="sigContent can not be empty")
    @UcloudParam(value="SigContent")
    private @NotEmpty(message="sigContent can not be empty") String sigContent;
    @NotNull(message="sigType can not be null")
    @UcloudParam(value="SigType")
    private @NotNull(message="sigType can not be null") Integer sigType;
    @NotNull(message="sigPurpose can not be null")
    @UcloudParam(value="SigPurpose")
    private @NotNull(message="sigPurpose can not be null") Integer sigPurpose;
    @NotNull(message="certificateType can not be null")
    @UcloudParam(value="CertificateType")
    private @NotNull(message="certificateType can not be null") Integer certificateType;
    @NotEmpty(message="description can not be empty")
    @UcloudParam(value="Description")
    private @NotEmpty(message="description can not be empty") String description;
    private String filePath;
    private String proxyFilePath;

    public CreateUSMSSignatureParam(@NotEmpty(message="sigContent can not be empty") @NotEmpty(message="sigContent can not be empty") String sigContent, @NotNull(message="sigType can not be null") @NotNull(message="sigType can not be null") Integer sigType, @NotNull(message="sigPurpose can not be null") @NotNull(message="sigPurpose can not be null") Integer sigPurpose, @NotNull(message="certificateType can not be null") @NotNull(message="certificateType can not be null") Integer certificateType, @NotEmpty(message="description can not be empty") @NotEmpty(message="description can not be empty") String description, @NotEmpty(message="filePath can not be empty") @NotEmpty(message="filePath can not be empty") String filePath) {
        super("CreateUSMSSignature");
        this.sigContent = sigContent;
        this.sigType = sigType;
        this.sigPurpose = sigPurpose;
        this.certificateType = certificateType;
        this.description = description;
        this.filePath = filePath;
    }

    @UcloudParam(value="File")
    public List<Param> checkFile() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.filePath == null || this.filePath.isEmpty()) {
            throw new ValidatorException("file can not be null");
        }
        params.add(new Param("File", (Object)FileUtil.getFileContent2StringAfterBase64Encode(this.filePath)));
        return params;
    }

    @UcloudParam(value="ProxyFile")
    public List<Param> checkProxyFile() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.proxyFilePath != null && !this.proxyFilePath.isEmpty()) {
            params.add(new Param("ProxyFile", (Object)FileUtil.getFileContent2StringAfterBase64Encode(this.filePath)));
        }
        return params;
    }

    public String getSigContent() {
        return this.sigContent;
    }

    public void setSigContent(String sigContent) {
        this.sigContent = sigContent;
    }

    public Integer getSigType() {
        return this.sigType;
    }

    public void setSigType(Integer sigType) {
        this.sigType = sigType;
    }

    public Integer getSigPurpose() {
        return this.sigPurpose;
    }

    public void setSigPurpose(Integer sigPurpose) {
        this.sigPurpose = sigPurpose;
    }

    public Integer getCertificateType() {
        return this.certificateType;
    }

    public void setCertificateType(Integer certificateType) {
        this.certificateType = certificateType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getProxyFilePath() {
        return this.proxyFilePath;
    }

    public void setProxyFilePath(String proxyFilePath) {
        this.proxyFilePath = proxyFilePath;
    }
}

