/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.usms.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;

public class GetUSMSSendReceiptParam
extends BaseRequestParam {
    @UcloudParam(value="Region")
    private String region;
    @UcloudParam(value="Zone")
    private String zone;
    private List<String> sessionNos;

    public GetUSMSSendReceiptParam(List<String> sessionNos) {
        super("GetUSMSSendReceipt");
        this.sessionNos = sessionNos;
    }

    @UcloudParam(value="SessionNos")
    public List<Param> checkPhoneNumbers() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.sessionNos == null || this.sessionNos.isEmpty()) {
            throw new ValidatorException("sessionNos can not be empty");
        }
        int size = this.sessionNos.size();
        String sessionNoFormat = "SessionNoSet.%d";
        for (int i = 0; i < size; ++i) {
            String sessionNo = this.sessionNos.get(i);
            if (sessionNo == null || sessionNo.isEmpty()) {
                throw new ValidatorException(String.format("sessionNo[%d] can not be empty", i));
            }
            params.add(new Param(String.format(sessionNoFormat, i), (Object)sessionNo));
        }
        return params;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public List<String> getSessionNos() {
        return this.sessionNos;
    }

    public void setSessionNos(List<String> sessionNos) {
        this.sessionNos = sessionNos;
    }
}

