/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.usms.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;

public class SendUSMSMessageParam
extends BaseRequestParam {
    @UcloudParam(value="Region")
    private String region;
    @UcloudParam(value="Zone")
    private String zone;
    private List<String> phoneNumbers;
    private List<String> templateParams;
    @NotEmpty(message="templateId can not be empty")
    @UcloudParam(value="TemplateId")
    private @NotEmpty(message="templateId can not be empty") String templateId;
    @UcloudParam(value="SigContent")
    private String sigContent;
    @UcloudParam(value="ExtendCode")
    private String extendCode;

    public SendUSMSMessageParam(List<String> phoneNumbers, String templateId) {
        super("SendUSMSMessage");
        this.phoneNumbers = phoneNumbers;
        this.templateId = templateId;
    }

    @UcloudParam(value="PhoneNumbers")
    public List<Param> checkPhoneNumbers() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.phoneNumbers == null || this.phoneNumbers.isEmpty()) {
            throw new ValidatorException("phoneNumbers can not be empty");
        }
        int size = this.phoneNumbers.size();
        String phoneNumberFormat = "PhoneNumbers.%d";
        for (int i = 0; i < size; ++i) {
            String phoneNumber = this.phoneNumbers.get(i);
            if (phoneNumber == null || phoneNumber.isEmpty()) {
                throw new ValidatorException(String.format("phoneNumbers[%d] can not be empty", i));
            }
            params.add(new Param(String.format(phoneNumberFormat, i), (Object)phoneNumber));
        }
        return params;
    }

    @UcloudParam(value="TemplateParams")
    public List<Param> checkTemplateParams() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.templateParams == null || this.templateParams.isEmpty()) {
            return params;
        }
        int size = this.templateParams.size();
        String templateParamFormat = "TemplateParams.%d";
        for (int i = 0; i < size; ++i) {
            String templateParam = this.templateParams.get(i);
            if (templateParam == null || templateParam.isEmpty()) {
                throw new ValidatorException(String.format("templateParams[%d] can not be empty", i));
            }
            params.add(new Param(String.format(templateParamFormat, i), (Object)templateParam));
        }
        return params;
    }

    public String getExtendCode() {
        return this.extendCode;
    }

    public void setExtendCode(String extendCode) {
        this.extendCode = extendCode;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public List<String> getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(List<String> templateParams) {
        this.templateParams = templateParams;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getSigContent() {
        return this.sigContent;
    }

    public void setSigContent(String sigContent) {
        this.sigContent = sigContent;
    }
}

