/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.bucket;

import cn.ucloud.ufile.UfileClient;
import cn.ucloud.ufile.api.bucket.BucketType;
import cn.ucloud.ufile.api.bucket.CreateBucketApi;
import cn.ucloud.ufile.api.bucket.DeleteBucketApi;
import cn.ucloud.ufile.api.bucket.DescribeBucketApi;
import cn.ucloud.ufile.api.bucket.UpdateBucketApi;
import cn.ucloud.ufile.auth.BucketAuthorizer;

public class BucketApiBuilder {
    protected UfileClient client;
    protected BucketAuthorizer authorizer;

    public BucketApiBuilder(UfileClient client, BucketAuthorizer authorizer) {
        this.client = client;
        this.authorizer = authorizer;
    }

    public CreateBucketApi createBucket(String bucketName, String region, BucketType type) {
        return new CreateBucketApi(this.authorizer, this.client.getHttpClient()).bucketName(bucketName).withType(type).atRegion(region);
    }

    public DeleteBucketApi deleteBucket(String bucketName) {
        return new DeleteBucketApi(this.authorizer, this.client.getHttpClient()).whichBucket(bucketName);
    }

    public UpdateBucketApi updateBucket(String bucketName, BucketType changeType) {
        return new UpdateBucketApi(this.authorizer, this.client.getHttpClient()).whichBucket(bucketName).changeType(changeType);
    }

    public DescribeBucketApi describeBucket() {
        return new DescribeBucketApi(this.authorizer, this.client.getHttpClient());
    }
}

