/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.AppendObjectResultBean;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.request.PutStreamRequestBuilder;
import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HexFormatter;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Response;

public class AppendObjectApi
extends UfileObjectApi<AppendObjectResultBean> {
    protected String keyName;
    protected byte[] appendData;
    protected long position;
    protected String mimeType;
    protected MediaType mediaType;
    protected String bucketName;
    private boolean isVerifyMd5 = true;
    private ProgressConfig progressConfig = ProgressConfig.callbackDefault();
    private int bufferSize = 524288;
    private OnProgressListener onProgressListener;

    protected AppendObjectApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public AppendObjectApi from(byte[] appendData, String mimeType) {
        this.appendData = appendData;
        this.mimeType = mimeType;
        this.mediaType = MediaType.parse((String)mimeType);
        return this;
    }

    public AppendObjectApi appendTo(String bucketName, String keyName, long position) {
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.position = position;
        return this;
    }

    public AppendObjectApi withVerifyMd5(boolean isVerifyMd5) {
        this.isVerifyMd5 = isVerifyMd5;
        return this;
    }

    public AppendObjectApi withProgressConfig(ProgressConfig config) {
        this.progressConfig = config == null ? this.progressConfig : config;
        return this;
    }

    public AppendObjectApi setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public AppendObjectApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        ArrayList<Parameter> query = new ArrayList<Parameter>();
        query.add(new Parameter("position", (Object)String.valueOf(this.position)));
        this.contentType = this.mediaType.toString();
        String contentMD5 = "";
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        PutStreamRequestBuilder builder = new PutStreamRequestBuilder(this.onProgressListener);
        String keyName_tmp = this.keyName + "?append&" + builder.generateUrlQuery(query);
        builder.setBufferSize((long)this.bufferSize);
        builder.baseUrl(this.generateFinalHost(this.bucketName, keyName_tmp)).setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date).mediaType(this.mediaType);
        builder.addHeader("Content-Length", String.valueOf(this.appendData.length));
        if (this.isVerifyMd5) {
            try {
                contentMD5 = HexFormatter.formatByteArray2HexString((byte[])Encoder.md5((byte[])this.appendData), (boolean)false);
                builder.addHeader("Content-MD5", contentMD5);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.PUT, this.bucketName, keyName_tmp, this.contentType, contentMD5, date).setOptional(this.authOptionalData));
        builder.addHeader("authorization", authorization);
        builder.params((Object)new ByteArrayInputStream(this.appendData));
        builder.setProgressConfig(this.progressConfig);
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.appendData == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'appendData' can not be null");
        }
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.mimeType == null || this.mimeType.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'mimeType' can not be null or empty");
        }
        if (this.mediaType == null) {
            throw new UfileParamException("The required param 'mimeType' is invalid");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
        if (this.position < 0L) {
            throw new UfileRequiredParamNotFoundException("The required param 'position' can not be below 0");
        }
    }

    public AppendObjectApi setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public void executeAsync(BaseHttpCallback<AppendObjectResultBean, UfileErrorBean> callback) {
        this.onProgressListener = callback;
        super.executeAsync(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppendObjectResultBean parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        AppendObjectResultBean appendObjectResultBean;
        try {
            Set names;
            AppendObjectResultBean result = new AppendObjectResultBean();
            String eTag = response.header("ETag", null);
            eTag = eTag == null ? null : eTag.replace("\"", "");
            result.seteTag(eTag);
            if (response.headers() != null && (names = response.headers().names()) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : names) {
                    headers.put(name, response.header(name, null));
                }
                result.setHeaders(headers);
            }
            appendObjectResultBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return appendObjectResultBean;
    }
}

