/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.CopyObjectResultBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.PutJsonRequestBuilder;
import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.Response;

public class CopyObjectApi
extends UfileObjectApi<CopyObjectResultBean> {
    protected String srcBucketName;
    protected String srcKeyName;
    protected String dstBucketName;
    protected String dstKeyName;
    protected Map<String, String> metadatas;
    protected String metadataDirective;

    protected CopyObjectApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public CopyObjectApi from(String srcBucketName, String srcKeyName) {
        this.srcBucketName = srcBucketName;
        this.srcKeyName = srcKeyName;
        return this;
    }

    public CopyObjectApi copyTo(String dstBucketName, String dstKeyName) {
        this.dstBucketName = dstBucketName;
        this.dstKeyName = dstKeyName;
        return this;
    }

    public CopyObjectApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    public CopyObjectApi withMetaDatas(Map<String, String> datas) {
        if (datas == null) {
            this.metadatas = null;
            return this;
        }
        this.metadatas = new HashMap<String, String>(datas);
        return this;
    }

    public CopyObjectApi addMetaData(Parameter<String> data) {
        if (data == null) {
            return this;
        }
        if (this.metadatas == null) {
            this.metadatas = new HashMap<String, String>();
        }
        this.metadatas.put(data.key, (String)data.value);
        return this;
    }

    public CopyObjectApi withMetadataDirective(String metadataDirective) {
        this.metadataDirective = metadataDirective;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        Set<String> keys;
        this.parameterValidat();
        this.contentType = "application/json; charset=utf-8";
        String contentMD5 = "";
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String xUfileCopySource = null;
        try {
            xUfileCopySource = "/" + Encoder.urlEncode((String)this.srcBucketName, (String)"UTF-8") + "/" + Encoder.urlEncode((String)this.srcKeyName, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UfileClientException("Occur error during URLEncode srcBucketName and srcKeyName", (Throwable)e);
        }
        PutJsonRequestBuilder builder = (PutJsonRequestBuilder)new PutJsonRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(this.generateFinalHost(this.dstBucketName, this.dstKeyName)).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("X-Ufile-Copy-Source", xUfileCopySource).addHeader("Date", date);
        if (this.metadataDirective != null) {
            builder.addHeader("X-Ufile-Metadata-Directive", this.metadataDirective);
        }
        if (this.metadatas != null && !this.metadatas.isEmpty() && (keys = this.metadatas.keySet()) != null) {
            for (String key : keys) {
                if (key == null || key.isEmpty()) continue;
                String value = this.metadatas.get(key);
                builder.addHeader("X-Ufile-Meta-" + key, value == null ? "" : value);
            }
        }
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.PUT, this.dstBucketName, this.dstKeyName, this.contentType, contentMD5, date).setOptional(this.authOptionalData));
        builder.addHeader("authorization", authorization);
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.srcBucketName == null || this.srcBucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'srcBucketName' can not be null or empty");
        }
        if (this.srcKeyName == null || this.srcKeyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'srcKeyName' can not be null or empty");
        }
        if (this.dstBucketName == null || this.dstBucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'dstBucketName' can not be null or empty");
        }
        if (this.dstKeyName == null || this.dstKeyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'dstKeyName' can not be null or empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyObjectResultBean parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        CopyObjectResultBean copyObjectResultBean;
        try {
            Set names;
            CopyObjectResultBean result = (CopyObjectResultBean)((Object)super.parseHttpResponse(response));
            String eTag = response.header("ETag", null);
            eTag = eTag == null ? null : eTag.replace("\"", "");
            result.seteTag(eTag);
            if (response.headers() != null && (names = response.headers().names()) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : names) {
                    headers.put(name, response.header(name, null));
                }
                result.setHeaders(headers);
            }
            copyObjectResultBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return copyObjectResultBean;
    }
}

