/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.ApiError;
import cn.ucloud.ufile.api.object.GenerateObjectPrivateUrlApi;
import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.bean.DownloadFileBean;
import cn.ucloud.ufile.bean.ObjectProfile;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileIOException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.UfileHttpException;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.Etag;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.JLog;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Response;

public class DownloadFileApi
extends UfileObjectApi<DownloadFileBean> {
    private String localPath;
    private String saveName;
    private ObjectProfile profile;
    private int expiresDuration = 86400;
    private int threadCount = 10;
    private ProgressConfig progressConfig;
    private long rangeStart;
    private long rangeEnd;
    private boolean isCover = true;
    private long totalSize = 0L;
    private int partCount = 0;
    private List<DownloadCallable> callList;
    private File finalFile;
    private AtomicLong bytesWritten;
    private AtomicLong bytesWrittenCache;
    private ExecutorService mFixedThreadPool;
    private int bufferSize = 524288;
    private OnProgressListener onProgressListener;
    private Timer progressTimer;
    private ProgressTask progressTask;

    protected DownloadFileApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
        this.RESP_CODE_SUCCESS = 206;
        this.progressConfig = ProgressConfig.callbackDefault();
    }

    public DownloadFileApi saveAt(String localPath, String saveName) {
        this.localPath = localPath;
        this.saveName = saveName;
        return this;
    }

    public DownloadFileApi which(ObjectProfile profile) {
        this.profile = profile;
        return this;
    }

    public DownloadFileApi withinRange(long start, long end) {
        this.rangeStart = start;
        this.rangeEnd = end;
        return this;
    }

    public DownloadFileApi together(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public DownloadFileApi withCoverage(boolean isCover) {
        this.isCover = isCover;
        return this;
    }

    public DownloadFileApi withProgressConfig(ProgressConfig config) {
        this.progressConfig = config == null ? this.progressConfig : config;
        return this;
    }

    public DownloadFileApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    public DownloadFileApi setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        int i;
        String absPath;
        File file;
        this.parameterValidat();
        this.partCount = 0;
        File dir = new File(this.localPath);
        if (!dir.exists() || dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        if ((file = new File(absPath = this.localPath + (this.localPath.endsWith(File.separator) ? "" : File.separator) + this.saveName)).exists() && file.isFile()) {
            if (this.isCover) {
                FileUtil.deleteFileCleanly((File)file);
                file = new File(absPath);
            } else {
                i = 1;
                boolean isExist = true;
                while (isExist) {
                    String tmpPath = absPath + String.format("-%d", i++);
                    file = new File(tmpPath);
                    if (file.exists() && !file.isDirectory()) continue;
                    isExist = false;
                    absPath = tmpPath;
                }
            }
        }
        this.finalFile = file;
        if (this.rangeEnd == 0L) {
            this.rangeEnd = this.profile.getContentLength() - 1L;
        }
        this.totalSize = this.rangeEnd - this.rangeStart + 1L;
        this.host = new GenerateObjectPrivateUrlApi(this.authorizer, this.objectConfig, this.profile.getKeyName(), this.profile.getBucket(), this.expiresDuration).withAuthOptionalData(this.authOptionalData).createUrl();
        this.partCount = (int)Math.ceil((double)this.totalSize * 1.0 / 4194304.0);
        switch (this.progressConfig.type) {
            case PROGRESS_INTERVAL_TIME: {
                this.progressConfig.interval = Math.max(0L, this.progressConfig.interval);
                break;
            }
            case PROGRESS_INTERVAL_PERCENT: {
                if (this.progressConfig.interval < 0L || this.progressConfig.interval > 100L) {
                    this.progressConfig.interval = 0L;
                    break;
                }
                this.progressConfig.interval = (long)((float)this.progressConfig.interval / 100.0f * (float)this.totalSize);
                break;
            }
            case PROGRESS_INTERVAL_BUFFER: {
                this.progressConfig.interval = Math.max(0L, Math.min(this.totalSize - 1L, this.progressConfig.interval));
            }
        }
        this.bytesWritten = new AtomicLong(0L);
        this.bytesWrittenCache = new AtomicLong(0L);
        this.callList = new ArrayList<DownloadCallable>();
        for (i = 0; i < this.partCount; ++i) {
            long start = Math.max((long)(i * 0x400000), this.rangeStart);
            long end = Math.min(this.rangeEnd, start + 0x400000L);
            GetRequestBuilder builder = (GetRequestBuilder)new GetRequestBuilder().baseUrl(this.host).addHeader("Range", String.format("bytes=%d-%d", start, end));
            builder.setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut);
            this.callList.add(new DownloadCallable(builder.build(this.httpClient.getOkHttpClient()), i));
        }
        this.mFixedThreadPool = Executors.newFixedThreadPool(this.threadCount);
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.localPath == null || this.localPath.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'localPath' can not be null or empty");
        }
        if (this.saveName == null || this.saveName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'saveName' can not be null or empty");
        }
        if (this.profile == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'profile' can not be null");
        }
        if (this.rangeStart < 0L) {
            throw new UfileParamException("Invalid range param 'start', start must be >= 0");
        }
        if (this.rangeEnd < 0L) {
            throw new UfileParamException("Invalid range param 'end', end must be >= 0");
        }
        if (this.rangeEnd > 0L && this.rangeEnd <= this.rangeStart) {
            throw new UfileParamException("Invalid range, end must be > start");
        }
        if (this.rangeEnd > this.profile.getContentLength() - 1L) {
            throw new UfileParamException("Invalid range, end is out of content-length");
        }
    }

    public DownloadFileApi setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadFileBean execute() throws UfileClientException {
        this.prepareData();
        try {
            if (this.onProgressListener != null && this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                this.progressTimer = new Timer();
                this.progressTask = new ProgressTask(this.totalSize);
                this.progressTimer.scheduleAtFixedRate((TimerTask)this.progressTask, this.progressConfig.interval, this.progressConfig.interval);
            }
            List futures = this.mFixedThreadPool.invokeAll(this.callList);
            if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                if (this.progressTask != null) {
                    this.progressTask.cancel();
                }
                if (this.progressTimer != null) {
                    this.progressTimer.cancel();
                }
                if (this.onProgressListener != null) {
                    AtomicLong atomicLong = this.bytesWritten;
                    synchronized (atomicLong) {
                        this.onProgressListener.onProgress(this.bytesWritten.get(), this.totalSize);
                    }
                }
            }
            if (futures == null) {
                throw new UfileClientException("Invoke futures are null!");
            }
            Map<String, String> metadatas = null;
            try {
                int len = futures.size();
                for (int i = len - 1; i > -1; --i) {
                    Future future = futures.get(i);
                    if (future == null) {
                        throw new UfileClientException("Invoke future is null!");
                    }
                    DownloadFileBean res = (DownloadFileBean)((Object)future.get());
                    if (metadatas != null || res == null || res.getMetadatas() == null) continue;
                    metadatas = res.getMetadatas();
                }
            }
            catch (ExecutionException e) {
                throw new UfileClientException(e.getMessage());
            }
            Etag etag = Etag.etag((File)this.finalFile, (int)0x400000);
            DownloadFileBean downloadFileBean = new DownloadFileBean().setContentType(this.profile.getContentType()).seteTag(etag == null ? null : etag.geteTag()).setFile(this.finalFile).setContentLength(this.finalFile.length()).setMetadatas(metadatas);
            return downloadFileBean;
        }
        catch (IOException e) {
            throw new UfileIOException("Calculate ETag error!", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new UfileClientException("Invoke part occur error!", (Throwable)e);
        }
        finally {
            this.mFixedThreadPool.shutdown();
        }
    }

    public void executeAsync(BaseHttpCallback<DownloadFileBean, UfileErrorBean> callback) {
        this.onProgressListener = callback;
        this.httpCallback = callback;
        this.okHttpClient.dispatcher().executorService().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DownloadFileApi.this.prepareData();
                    if (DownloadFileApi.this.onProgressListener != null && ((DownloadFileApi)DownloadFileApi.this).progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                        DownloadFileApi.this.progressTimer = new Timer();
                        DownloadFileApi.this.progressTask = new ProgressTask(DownloadFileApi.this.totalSize);
                        DownloadFileApi.this.progressTimer.scheduleAtFixedRate((TimerTask)DownloadFileApi.this.progressTask, ((DownloadFileApi)DownloadFileApi.this).progressConfig.interval, ((DownloadFileApi)DownloadFileApi.this).progressConfig.interval);
                    }
                    List futures = DownloadFileApi.this.mFixedThreadPool.invokeAll(DownloadFileApi.this.callList);
                    if (((DownloadFileApi)DownloadFileApi.this).progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                        if (DownloadFileApi.this.progressTask != null) {
                            DownloadFileApi.this.progressTask.cancel();
                        }
                        if (DownloadFileApi.this.progressTimer != null) {
                            DownloadFileApi.this.progressTimer.cancel();
                        }
                        if (DownloadFileApi.this.onProgressListener != null) {
                            AtomicLong atomicLong = DownloadFileApi.this.bytesWritten;
                            synchronized (atomicLong) {
                                DownloadFileApi.this.onProgressListener.onProgress(DownloadFileApi.this.bytesWritten.get(), DownloadFileApi.this.totalSize);
                            }
                        }
                    }
                    if (futures == null) {
                        throw new UfileClientException("Invoke futures are null!");
                    }
                    Map<String, String> metadatas = null;
                    try {
                        int len = futures.size();
                        for (int i = len - 1; i > -1; --i) {
                            Future future = futures.get(i);
                            if (future == null) {
                                throw new UfileClientException("Invoke future is null!");
                            }
                            DownloadFileBean res = (DownloadFileBean)((Object)future.get());
                            if (metadatas != null || res == null || res.getMetadatas() == null) continue;
                            metadatas = res.getMetadatas();
                        }
                    }
                    catch (ExecutionException e) {
                        throw new UfileClientException(e.getMessage());
                    }
                    if (DownloadFileApi.this.httpCallback != null) {
                        try {
                            Etag etag = Etag.etag((File)DownloadFileApi.this.finalFile, (int)0x400000);
                            DownloadFileApi.this.httpCallback.onResponse((Object)new DownloadFileBean().setContentType(DownloadFileApi.this.profile.getContentType()).seteTag(etag == null ? null : etag.geteTag()).setFile(DownloadFileApi.this.finalFile).setContentLength(DownloadFileApi.this.finalFile.length()).setMetadatas(metadatas));
                        }
                        catch (IOException e) {
                            DownloadFileApi.this.httpCallback.onError(null, new ApiError(ApiError.ErrorType.ERROR_NORMAL_ERROR, (Throwable)new UfileIOException("Calculate ETag error!", (Throwable)e)), null);
                        }
                    }
                }
                catch (UfileClientException e) {
                    if (DownloadFileApi.this.httpCallback != null) {
                        DownloadFileApi.this.httpCallback.onError(null, new ApiError(ApiError.ErrorType.ERROR_PARAMS_ILLEGAL, (Throwable)e), null);
                    }
                }
                catch (InterruptedException e) {
                    if (DownloadFileApi.this.httpCallback != null) {
                        DownloadFileApi.this.httpCallback.onError(null, new ApiError(ApiError.ErrorType.ERROR_NORMAL_ERROR, "Invoke part occur error!", (Throwable)e), null);
                    }
                }
                finally {
                    DownloadFileApi.this.mFixedThreadPool.shutdown();
                }
            }
        });
    }

    public DownloadFileBean parseHttpResponse(Response response) throws UfileIOException, NumberFormatException {
        InputStream is = null;
        RandomAccessFile raf = null;
        DownloadFileBean result = new DownloadFileBean();
        try {
            result.setContentLength(response.body().contentLength());
            result.setContentType(response.header("Content-Type"));
            String range = response.header("Content-Range", "");
            range = range.replace("bytes", "");
            String[] rangeArr = range.split("-");
            long start = Long.parseLong(rangeArr[0].trim());
            rangeArr = rangeArr[1].trim().split("/");
            long total = Long.parseLong(rangeArr[1].trim());
            JLog.T((String)this.TAG, (String)("[Content-Range]:" + range + " [start]:" + start + " [total]:" + total));
            is = response.body().byteStream();
            raf = new RandomAccessFile(this.finalFile, "rwd");
            raf.seek(start - this.rangeStart);
            byte[] buffer = new byte[this.bufferSize];
            int len = 0;
            while ((len = is.read(buffer)) > 0) {
                raf.write(buffer, 0, len);
                if (this.onProgressListener == null) continue;
                long written = this.bytesWritten.addAndGet(len);
                long cache = this.bytesWrittenCache.addAndGet(len);
                if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME || written < total && cache < this.progressConfig.interval) continue;
                this.bytesWrittenCache.set(0L);
                this.onProgressListener.onProgress(written, total);
            }
        }
        catch (IOException e) {
            try {
                throw new UfileIOException("Occur IOException while IO stream");
            }
            catch (Throwable throwable) {
                FileUtil.close((AutoCloseable[])new AutoCloseable[]{raf, is, response.body()});
                throw throwable;
            }
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{raf, is, response.body()});
        return result;
    }

    private class DownloadCallable
    implements Callable<DownloadFileBean> {
        private Call call;
        private int index;

        public DownloadCallable(Call call, int index) {
            this.call = call;
            this.index = index;
        }

        @Override
        public DownloadFileBean call() throws Exception {
            try {
                Set names;
                Response response = this.call.execute();
                if (response == null) {
                    throw new UfileHttpException("Response is null");
                }
                if (response.code() / 100 != 2) {
                    throw new UfileHttpException(DownloadFileApi.this.parseErrorResponse(response).toString());
                }
                DownloadFileBean result = DownloadFileApi.this.parseHttpResponse(response);
                if ((this.index == 0 || this.index == DownloadFileApi.this.partCount - 1) && response.headers() != null && (names = response.headers().names()) != null) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    for (String name : names) {
                        headers.put(name, response.header(name, null));
                        if (name == null || !name.startsWith("X-Ufile-Meta-")) continue;
                        String key = name.substring(13).toLowerCase();
                        metadata.put(key, response.header(name, ""));
                    }
                    result.setHeaders(headers);
                    result.setMetadatas(metadata);
                }
                return result;
            }
            catch (Throwable t) {
                throw new UfileClientException(t);
            }
        }
    }

    private class ProgressTask
    extends TimerTask {
        private long totalSize = 0L;

        private ProgressTask(long totalSize) {
            this.totalSize = totalSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DownloadFileApi.this.onProgressListener != null) {
                AtomicLong atomicLong = DownloadFileApi.this.bytesWritten;
                synchronized (atomicLong) {
                    DownloadFileApi.this.onProgressListener.onProgress(DownloadFileApi.this.bytesWritten.get(), this.totalSize);
                }
            }
        }
    }
}

