/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectDownloadAuthParam;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class GenerateObjectPrivateUrlApi {
    private ObjectAuthorizer authorizer;
    private ObjectConfig objectConfig;
    private String keyName;
    private String bucketName;
    private long expiresDuration;
    private String attachmentFileName;
    private JsonElement authOptionalData;
    protected String iopCmd;

    protected GenerateObjectPrivateUrlApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, String keyName, String bucketName, int expiresDuration) {
        this.authorizer = authorizer;
        this.objectConfig = objectConfig;
        this.keyName = keyName;
        this.bucketName = bucketName;
        this.expiresDuration = expiresDuration;
    }

    public GenerateObjectPrivateUrlApi withAttachment(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
        return this;
    }

    public GenerateObjectPrivateUrlApi withAttachment() {
        this.attachmentFileName = this.keyName;
        return this;
    }

    public GenerateObjectPrivateUrlApi withIopCmd(String iopCmd) {
        this.iopCmd = iopCmd;
        return this;
    }

    public GenerateObjectPrivateUrlApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    public String createUrl() throws UfileClientException {
        this.parameterValidat();
        long expiresTime = System.currentTimeMillis() / 1000L + this.expiresDuration;
        String signature = this.authorizer.authorizePrivateUrl((ObjectDownloadAuthParam)new ObjectDownloadAuthParam(HttpMethod.GET, this.bucketName, this.keyName, expiresTime).setOptional(this.authOptionalData));
        GetRequestBuilder builder = (GetRequestBuilder)new GetRequestBuilder().baseUrl(this.generateFinalHost(this.bucketName, this.keyName));
        builder.addParam(new Parameter("UCloudPublicKey", (Object)this.authorizer.getPublicKey())).addParam(new Parameter("Signature", (Object)signature)).addParam(new Parameter("Expires", (Object)String.valueOf(expiresTime)));
        if (this.attachmentFileName != null && !this.attachmentFileName.isEmpty()) {
            try {
                this.attachmentFileName = Encoder.urlEncode((String)this.attachmentFileName, (String)"UTF-8");
                builder.addParam(new Parameter("ufileattname", (Object)this.attachmentFileName));
            }
            catch (UnsupportedEncodingException e) {
                throw new UfileClientException("Occur error during URLEncode attachmentFileName", (Throwable)e);
            }
        }
        String url = builder.generateGetUrl(builder.getBaseUrl(), (List)builder.getParams());
        if (this.iopCmd != null && !this.iopCmd.isEmpty()) {
            List params = (List)builder.getParams();
            url = params == null || params.isEmpty() ? String.format("%s?%s", url, this.iopCmd) : String.format("%s&%s", url, this.iopCmd);
        }
        return url;
    }

    public void createUrlAsync(final CreatePrivateUrlCallback callback) {
        new Thread(){

            @Override
            public void run() {
                block3: {
                    try {
                        String url = GenerateObjectPrivateUrlApi.this.createUrl();
                        if (callback != null) {
                            callback.onSuccess(url);
                        }
                    }
                    catch (UfileClientException e) {
                        if (callback == null) break block3;
                        callback.onFailed(e);
                    }
                }
            }
        }.start();
    }

    private String generateFinalHost(String bucketName, String keyName) throws UfileClientException {
        if (this.objectConfig == null) {
            return null;
        }
        if (this.objectConfig.isCustomDomain()) {
            return String.format("%s/%s", this.objectConfig.getCustomHost(), keyName);
        }
        try {
            bucketName = Encoder.urlEncode((String)bucketName, (String)"UTF-8");
            String region = Encoder.urlEncode((String)this.objectConfig.getRegion(), (String)"UTF-8");
            String proxySuffix = Encoder.urlEncode((String)this.objectConfig.getProxySuffix(), (String)"UTF-8");
            keyName = Encoder.urlEncode((String)keyName, (String)"UTF-8");
            return this.objectConfig.getProtocol().getValue() + String.format("%s.%s.%s/%s", bucketName, region, proxySuffix, keyName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UfileClientException("Occur error during URLEncode bucketName and keyName", (Throwable)e);
        }
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
        if (this.expiresDuration <= 0L) {
            throw new UfileParamException("The required param 'expiresDuration' must > 0");
        }
    }

    public static interface CreatePrivateUrlCallback {
        public void onSuccess(String var1);

        public void onFailed(UfileClientException var1);
    }
}

