/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.Parameter;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class GenerateObjectPublicUrlApi {
    private ObjectConfig objectConfig;
    private String keyName;
    private String bucketName;
    private String attachmentFileName;
    protected String iopCmd;

    protected GenerateObjectPublicUrlApi(ObjectConfig objectConfig, String keyName, String bucketName) {
        this.objectConfig = objectConfig;
        this.keyName = keyName;
        this.bucketName = bucketName;
    }

    public GenerateObjectPublicUrlApi withAttachment(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
        return this;
    }

    public GenerateObjectPublicUrlApi withAttachment() {
        this.attachmentFileName = this.keyName;
        return this;
    }

    public GenerateObjectPublicUrlApi withIopCmd(String iopCmd) {
        this.iopCmd = iopCmd;
        return this;
    }

    public String createUrl() throws UfileClientException {
        this.parameterValidat();
        GetRequestBuilder builder = (GetRequestBuilder)new GetRequestBuilder().baseUrl(this.generateFinalHost(this.bucketName, this.keyName));
        if (this.attachmentFileName != null && !this.attachmentFileName.isEmpty()) {
            try {
                this.attachmentFileName = Encoder.urlEncode((String)this.attachmentFileName, (String)"UTF-8");
                builder.addParam(new Parameter("ufileattname", (Object)this.attachmentFileName));
            }
            catch (UnsupportedEncodingException e) {
                throw new UfileClientException("Occur error during URLEncode attachmentFileName", (Throwable)e);
            }
        }
        String url = builder.generateGetUrl(builder.getBaseUrl(), (List)builder.getParams());
        if (this.iopCmd != null && !this.iopCmd.isEmpty()) {
            List params = (List)builder.getParams();
            url = params == null || params.isEmpty() ? String.format("%s?%s", url, this.iopCmd) : String.format("%s&%s", url, this.iopCmd);
        }
        return url;
    }

    private String generateFinalHost(String bucketName, String keyName) throws UfileClientException {
        if (this.objectConfig == null) {
            return null;
        }
        if (this.objectConfig.isCustomDomain()) {
            return String.format("%s/%s", this.objectConfig.getCustomHost(), keyName);
        }
        try {
            bucketName = Encoder.urlEncode((String)bucketName, (String)"UTF-8");
            String region = Encoder.urlEncode((String)this.objectConfig.getRegion(), (String)"UTF-8");
            String proxySuffix = Encoder.urlEncode((String)this.objectConfig.getProxySuffix(), (String)"UTF-8");
            keyName = Encoder.urlEncode((String)keyName, (String)"UTF-8");
            return this.objectConfig.getProtocol().getValue() + String.format("%s.%s.%s/%s", bucketName, region, proxySuffix, keyName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UfileClientException("Occur error during URLEncode bucketName and keyName", (Throwable)e);
        }
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
    }
}

