/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.bean.DownloadFileBean;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileIOException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Response;

public class GetFileApi
extends UfileObjectApi<DownloadFileBean> {
    private String localPath;
    private String saveName;
    private boolean isCover = true;
    private ProgressConfig progressConfig;
    private AtomicLong bytesWritten;
    private AtomicLong bytesWrittenCache;
    private long rangeStart;
    private long rangeEnd;
    private int bufferSize = 524288;
    private Timer progressTimer;
    private ProgressTask progressTask;
    private OnProgressListener onProgressListener;

    protected GetFileApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
        this.RESP_CODE_SUCCESS = 200;
        this.host = objectConfig.getCustomHost();
        this.progressConfig = ProgressConfig.callbackDefault();
    }

    public GetFileApi saveAt(String localPath, String saveName) {
        this.localPath = localPath;
        this.saveName = saveName;
        return this;
    }

    public GetFileApi withCoverage(boolean isCover) {
        this.isCover = isCover;
        return this;
    }

    public GetFileApi withinRange(long start, long end) {
        this.rangeStart = start;
        this.rangeEnd = end;
        return this;
    }

    public GetFileApi withProgressConfig(ProgressConfig config) {
        this.progressConfig = config == null ? this.progressConfig : config;
        return this;
    }

    public GetFileApi setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    protected void prepareData() throws UfileParamException {
        this.parameterValidat();
        this.bytesWritten = new AtomicLong(0L);
        this.bytesWrittenCache = new AtomicLong(0L);
        this.call = new GetRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(this.host).addHeader("Range", String.format("bytes=%d-%s", this.rangeStart, this.rangeEnd == 0L ? "" : Long.valueOf(this.rangeEnd))).build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.host == null || this.host.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'url' can not be null or empty");
        }
        if (this.localPath == null || this.localPath.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'localPath' can not be null or empty");
        }
        if (this.saveName == null || this.saveName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'saveName' can not be null or empty");
        }
        if (this.rangeStart < 0L) {
            throw new UfileParamException("Invalid range param 'start', start must be >= 0");
        }
        if (this.rangeEnd < 0L) {
            throw new UfileParamException("Invalid range param 'end', end must be >= 0");
        }
        if (this.rangeEnd > 0L && this.rangeEnd <= this.rangeStart) {
            throw new UfileParamException("Invalid range, end must be > start");
        }
    }

    public GetFileApi setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public void executeAsync(BaseHttpCallback<DownloadFileBean, UfileErrorBean> callback) {
        this.onProgressListener = callback;
        super.executeAsync(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadFileBean parseHttpResponse(Response response) throws UfileIOException {
        DownloadFileBean result;
        FileOutputStream fos;
        InputStream is;
        block31: {
            Serializable dir;
            long contentLength;
            block32: {
                is = null;
                fos = null;
                result = new DownloadFileBean();
                contentLength = response.body().contentLength();
                try {
                    String absPath;
                    File file;
                    Set names;
                    result.setContentLength(contentLength);
                    result.setContentType(response.header("Content-Type"));
                    result.seteTag(response.header("ETag") == null ? null : response.header("ETag").replace("\"", ""));
                    if (response.headers() != null && (names = response.headers().names()) != null) {
                        HashMap<String, String> headers = new HashMap<String, String>();
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        for (String name : names) {
                            headers.put(name, response.header(name, null));
                            if (name == null || !name.startsWith("X-Ufile-Meta-")) continue;
                            String key = name.substring(13).toLowerCase();
                            metadata.put(key, response.header(name, ""));
                        }
                        result.setHeaders(headers);
                        result.setMetadatas(metadata);
                    }
                    if (this.onProgressListener != null) {
                        switch (this.progressConfig.type) {
                            case PROGRESS_INTERVAL_TIME: {
                                this.progressConfig.interval = Math.max(0L, this.progressConfig.interval);
                                this.progressTimer = new Timer();
                                this.progressTask = new ProgressTask(contentLength);
                                this.progressTimer.scheduleAtFixedRate((TimerTask)this.progressTask, this.progressConfig.interval, this.progressConfig.interval);
                                break;
                            }
                            case PROGRESS_INTERVAL_PERCENT: {
                                if (this.progressConfig.interval < 0L || this.progressConfig.interval > 100L) {
                                    this.progressConfig.interval = 0L;
                                    break;
                                }
                                this.progressConfig.interval = (long)((float)this.progressConfig.interval / 100.0f * (float)contentLength);
                                break;
                            }
                            case PROGRESS_INTERVAL_BUFFER: {
                                this.progressConfig.interval = Math.max(0L, Math.min(contentLength - 1L, this.progressConfig.interval));
                            }
                        }
                    }
                    if (!(dir = new File(this.localPath)).exists() || dir.exists() && !dir.isDirectory()) {
                        dir.mkdirs();
                    }
                    if ((file = new File(absPath = this.localPath + (this.localPath.endsWith(File.separator) ? "" : File.separator) + this.saveName)).exists() && file.isFile()) {
                        if (this.isCover) {
                            FileUtil.deleteFileCleanly((File)file);
                            file = new File(absPath);
                        } else {
                            int i = 1;
                            boolean isExist = true;
                            while (isExist) {
                                String tmpPath = absPath + String.format("-%d", i++);
                                file = new File(tmpPath);
                                if (file.exists() && !file.isDirectory()) continue;
                                isExist = false;
                                absPath = tmpPath;
                            }
                        }
                    }
                    is = response.body().byteStream();
                    fos = new FileOutputStream(file);
                    byte[] buffer = new byte[this.bufferSize];
                    int len = 0;
                    while ((len = is.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                        if (this.onProgressListener == null) continue;
                        long written = this.bytesWritten.addAndGet(len);
                        long cache = this.bytesWrittenCache.addAndGet(len);
                        if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME || written < contentLength && cache < this.progressConfig.interval) continue;
                        this.bytesWrittenCache.set(0L);
                        this.onProgressListener.onProgress(written, contentLength);
                    }
                    result.setFile(file);
                    if (this.progressConfig.type != ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) break block31;
                    if (this.progressTask == null) break block32;
                }
                catch (IOException e) {
                    try {
                        throw new UfileIOException("Occur IOException while IO stream");
                    }
                    catch (Throwable throwable) {
                        if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                            if (this.progressTask != null) {
                                this.progressTask.cancel();
                            }
                            if (this.progressTimer != null) {
                                this.progressTimer.cancel();
                            }
                            if (this.onProgressListener != null) {
                                AtomicLong atomicLong = this.bytesWritten;
                                synchronized (atomicLong) {
                                    this.onProgressListener.onProgress(this.bytesWritten.get(), contentLength);
                                }
                            }
                        }
                        FileUtil.close((AutoCloseable[])new AutoCloseable[]{fos, is, response.body()});
                        throw throwable;
                    }
                }
                this.progressTask.cancel();
            }
            if (this.progressTimer != null) {
                this.progressTimer.cancel();
            }
            if (this.onProgressListener != null) {
                dir = this.bytesWritten;
                synchronized (dir) {
                    this.onProgressListener.onProgress(this.bytesWritten.get(), contentLength);
                }
            }
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{fos, is, response.body()});
        return result;
    }

    private class ProgressTask
    extends TimerTask {
        private long totalSize = 0L;

        private ProgressTask(long totalSize) {
            this.totalSize = totalSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GetFileApi.this.onProgressListener != null) {
                AtomicLong atomicLong = GetFileApi.this.bytesWritten;
                synchronized (atomicLong) {
                    GetFileApi.this.onProgressListener.onProgress(GetFileApi.this.bytesWritten.get(), this.totalSize);
                }
            }
        }
    }
}

