/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.bean.DownloadStreamBean;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileIOException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Response;

public class GetStreamApi
extends UfileObjectApi<DownloadStreamBean> {
    private OutputStream outputStream;
    private ProgressConfig progressConfig;
    private AtomicLong bytesWritten;
    private AtomicLong bytesWrittenCache;
    private long rangeStart;
    private long rangeEnd;
    private int bufferSize = 524288;
    private OnProgressListener onProgressListener;
    private Timer progressTimer;
    private ProgressTask progressTask;

    protected GetStreamApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
        this.RESP_CODE_SUCCESS = 200;
        this.host = objectConfig.getCustomHost();
        this.progressConfig = ProgressConfig.callbackDefault();
    }

    public GetStreamApi withinRange(long start, long end) {
        this.rangeStart = start;
        this.rangeEnd = end;
        return this;
    }

    public GetStreamApi withProgressConfig(ProgressConfig config) {
        this.progressConfig = config == null ? this.progressConfig : config;
        return this;
    }

    public GetStreamApi redirectStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public GetStreamApi setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    protected void prepareData() throws UfileParamException {
        this.parameterValidat();
        this.bytesWritten = new AtomicLong(0L);
        this.bytesWrittenCache = new AtomicLong(0L);
        this.call = new GetRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(this.host).addHeader("Range", String.format("bytes=%d-%s", this.rangeStart, this.rangeEnd == 0L ? "" : Long.valueOf(this.rangeEnd))).build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.host == null || this.host.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'url' can not be null or empty");
        }
        if (this.rangeStart < 0L) {
            throw new UfileParamException("Invalid range param 'start', start must be >= 0");
        }
        if (this.rangeEnd < 0L) {
            throw new UfileParamException("Invalid range param 'end', end must be >= 0");
        }
        if (this.rangeEnd > 0L && this.rangeEnd <= this.rangeStart) {
            throw new UfileParamException("Invalid range, end must be > start");
        }
    }

    public GetStreamApi setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public void executeAsync(BaseHttpCallback<DownloadStreamBean, UfileErrorBean> callback) {
        this.onProgressListener = callback;
        super.executeAsync(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DownloadStreamBean parseHttpResponse(Response response) throws UfileIOException {
        InputStream is;
        DownloadStreamBean result;
        block25: {
            Object buffer;
            long contentLength;
            block26: {
                Set names;
                result = new DownloadStreamBean();
                contentLength = response.body().contentLength();
                result.setContentLength(contentLength);
                result.setContentType(response.header("Content-Type"));
                result.setContentMD5(response.header("Content-MD5"));
                result.seteTag(response.header("ETag") == null ? null : response.header("ETag").replace("\"", ""));
                if (response.headers() != null && (names = response.headers().names()) != null) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    for (String name : names) {
                        headers.put(name, response.header(name, null));
                        if (name == null || !name.startsWith("X-Ufile-Meta-")) continue;
                        String key = name.substring(13).toLowerCase();
                        metadata.put(key, response.header(name, ""));
                    }
                    result.setHeaders(headers);
                    result.setMetadatas(metadata);
                }
                is = response.body().byteStream();
                if (this.outputStream == null) {
                    result.setInputStream(is);
                    return result;
                }
                if (this.onProgressListener != null) {
                    switch (this.progressConfig.type) {
                        case PROGRESS_INTERVAL_TIME: {
                            this.progressConfig.interval = Math.max(0L, this.progressConfig.interval);
                            this.progressTimer = new Timer();
                            this.progressTask = new ProgressTask(contentLength);
                            this.progressTimer.scheduleAtFixedRate((TimerTask)this.progressTask, this.progressConfig.interval, this.progressConfig.interval);
                            break;
                        }
                        case PROGRESS_INTERVAL_PERCENT: {
                            if (this.progressConfig.interval < 0L || this.progressConfig.interval > 100L) {
                                this.progressConfig.interval = 0L;
                                break;
                            }
                            this.progressConfig.interval = (long)((float)this.progressConfig.interval / 100.0f * (float)contentLength);
                            break;
                        }
                        case PROGRESS_INTERVAL_BUFFER: {
                            this.progressConfig.interval = Math.max(0L, Math.min(contentLength - 1L, this.progressConfig.interval));
                            break;
                        }
                    }
                }
                try {
                    buffer = new byte[this.bufferSize];
                    int len = 0;
                    while ((len = is.read((byte[])buffer)) > 0) {
                        this.outputStream.write((byte[])buffer, 0, len);
                        if (this.onProgressListener == null) continue;
                        long written = this.bytesWritten.addAndGet(len);
                        long cache = this.bytesWrittenCache.addAndGet(len);
                        if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME || written < contentLength && cache < this.progressConfig.interval) continue;
                        this.bytesWrittenCache.set(0L);
                        this.onProgressListener.onProgress(written, contentLength);
                    }
                    if (this.progressConfig.type != ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) break block25;
                    if (this.progressTask == null) break block26;
                }
                catch (IOException e) {
                    try {
                        throw new UfileIOException("Occur IOException while IO stream");
                    }
                    catch (Throwable throwable) {
                        if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                            if (this.progressTask != null) {
                                this.progressTask.cancel();
                            }
                            if (this.progressTimer != null) {
                                this.progressTimer.cancel();
                            }
                            if (this.onProgressListener != null) {
                                AtomicLong atomicLong = this.bytesWritten;
                                // MONITORENTER : atomicLong
                                this.onProgressListener.onProgress(this.bytesWritten.get(), contentLength);
                                // MONITOREXIT : atomicLong
                            }
                        }
                        FileUtil.close((AutoCloseable[])new AutoCloseable[]{this.outputStream, is, response.body()});
                        throw throwable;
                    }
                }
                this.progressTask.cancel();
            }
            if (this.progressTimer != null) {
                this.progressTimer.cancel();
            }
            if (this.onProgressListener != null) {
                AtomicLong atomicLong = this.bytesWritten;
                buffer = atomicLong;
                // MONITORENTER : atomicLong
                this.onProgressListener.onProgress(this.bytesWritten.get(), contentLength);
                // MONITOREXIT : buffer
            }
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{this.outputStream, is, response.body()});
        return result;
    }

    private class ProgressTask
    extends TimerTask {
        private long totalSize = 0L;

        private ProgressTask(long totalSize) {
            this.totalSize = totalSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GetStreamApi.this.onProgressListener != null) {
                AtomicLong atomicLong = GetStreamApi.this.bytesWritten;
                synchronized (atomicLong) {
                    GetStreamApi.this.onProgressListener.onProgress(GetStreamApi.this.bytesWritten.get(), this.totalSize);
                }
            }
        }
    }
}

