/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.UfileClient;
import cn.ucloud.ufile.api.object.AppendObjectApi;
import cn.ucloud.ufile.api.object.CopyObjectApi;
import cn.ucloud.ufile.api.object.DeleteObjectApi;
import cn.ucloud.ufile.api.object.DownloadFileApi;
import cn.ucloud.ufile.api.object.GenerateObjectPrivateUrlApi;
import cn.ucloud.ufile.api.object.GenerateObjectPublicUrlApi;
import cn.ucloud.ufile.api.object.GetFileApi;
import cn.ucloud.ufile.api.object.GetStreamApi;
import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.ObjectListApi;
import cn.ucloud.ufile.api.object.ObjectListWithDirFormatApi;
import cn.ucloud.ufile.api.object.ObjectProfileApi;
import cn.ucloud.ufile.api.object.ObjectRestoreApi;
import cn.ucloud.ufile.api.object.PutFileApi;
import cn.ucloud.ufile.api.object.PutStreamApi;
import cn.ucloud.ufile.api.object.RenameObjectApi;
import cn.ucloud.ufile.api.object.StorageTypeSwitchApi;
import cn.ucloud.ufile.api.object.UploadFileHitApi;
import cn.ucloud.ufile.api.object.UploadStreamHitApi;
import cn.ucloud.ufile.api.object.multi.AbortMultiUploadApi;
import cn.ucloud.ufile.api.object.multi.FinishMultiUploadApi;
import cn.ucloud.ufile.api.object.multi.InitMultiUploadApi;
import cn.ucloud.ufile.api.object.multi.MultiUploadInfo;
import cn.ucloud.ufile.api.object.multi.MultiUploadPartApi;
import cn.ucloud.ufile.api.object.multi.MultiUploadPartState;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectRemoteAuthorization;
import cn.ucloud.ufile.bean.ObjectProfile;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileIOException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.util.Etag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ObjectApiBuilder {
    protected UfileClient client;
    protected ObjectAuthorizer authorizer;
    protected ObjectConfig objectConfig;

    public ObjectApiBuilder(UfileClient client, ObjectAuthorizer authorizer, ObjectConfig objectConfig) {
        this.client = client;
        this.authorizer = authorizer;
        if (authorizer instanceof ObjectRemoteAuthorization) {
            ((ObjectRemoteAuthorization)authorizer).setHttpClient(client.getHttpClient());
        }
        this.objectConfig = objectConfig;
    }

    public GenerateObjectPublicUrlApi getDownloadUrlFromPublicBucket(String keyName, String bucketName) {
        return new GenerateObjectPublicUrlApi(this.objectConfig, keyName, bucketName);
    }

    public GenerateObjectPrivateUrlApi getDownloadUrlFromPrivateBucket(String keyName, String bucketName, int expiresDuration) {
        return new GenerateObjectPrivateUrlApi(this.authorizer, this.objectConfig, keyName, bucketName, expiresDuration);
    }

    public GetFileApi getFile(String downloadUrl) {
        return new GetFileApi(this.authorizer, new ObjectConfig(downloadUrl), this.client.getHttpClient());
    }

    public GetStreamApi getStream(String downloadUrl) {
        return new GetStreamApi(this.authorizer, new ObjectConfig(downloadUrl), this.client.getHttpClient());
    }

    public PutFileApi putObject(File file, String mimeType) {
        return new PutFileApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).from(file, mimeType);
    }

    public PutStreamApi putObject(InputStream inputStream, long contentLength, String mimeType) {
        return new PutStreamApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).from(inputStream, contentLength, mimeType);
    }

    public AppendObjectApi appendObject(byte[] appendData, String mimeType) {
        return new AppendObjectApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).from(appendData, mimeType);
    }

    public UploadFileHitApi uploadHit(File file) {
        return new UploadFileHitApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).from(file);
    }

    public UploadStreamHitApi uploadHit(InputStream inputStream) {
        return new UploadStreamHitApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).from(inputStream);
    }

    public DeleteObjectApi deleteObject(String keyName, String bucketName) {
        return new DeleteObjectApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).keyName(keyName).atBucket(bucketName);
    }

    public ObjectProfileApi objectProfile(String keyName, String bucketName) {
        return new ObjectProfileApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(keyName).atBucket(bucketName);
    }

    public ObjectListApi objectList(String bucketName) {
        return new ObjectListApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).atBucket(bucketName);
    }

    public ObjectListWithDirFormatApi objectListWithDirFormat(String bucketName) {
        return new ObjectListWithDirFormatApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).atBucket(bucketName);
    }

    public InitMultiUploadApi initMultiUpload(String keyName, String mimeType, String bucketName) {
        return new InitMultiUploadApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).nameAs(keyName).withMimeType(mimeType).toBucket(bucketName);
    }

    public MultiUploadPartApi multiUploadPart(MultiUploadInfo state, byte[] part, int partIndex) {
        return new MultiUploadPartApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(state).from(part, partIndex);
    }

    public MultiUploadPartApi multiUploadPart(MultiUploadInfo state, byte[] part, int offset, int length, int partIndex) {
        return new MultiUploadPartApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(state).from(part, offset, length, partIndex);
    }

    public AbortMultiUploadApi abortMultiUpload(MultiUploadInfo state) {
        return new AbortMultiUploadApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(state);
    }

    public FinishMultiUploadApi finishMultiUpload(MultiUploadInfo state, List<MultiUploadPartState> partStates) {
        return new FinishMultiUploadApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(state, partStates);
    }

    public DownloadFileApi downloadFile(ObjectProfile profile) {
        return new DownloadFileApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(profile);
    }

    public ObjectRestoreApi objectRestore(String keyName, String bucketName) {
        return new ObjectRestoreApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(keyName).atBucket(bucketName);
    }

    public CopyObjectApi copyObject(String srcBucket, String srcKeyName) {
        return new CopyObjectApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).from(srcBucket, srcKeyName);
    }

    public RenameObjectApi renameObject(String bucketName, String keyName) {
        return new RenameObjectApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(bucketName, keyName);
    }

    public StorageTypeSwitchApi switchStorageType(String bucketName, String keyName) {
        return new StorageTypeSwitchApi(this.authorizer, this.objectConfig, this.client.getHttpClient()).which(bucketName, keyName);
    }

    public boolean compareEtag(File localFile, String keyName, String bucketName) throws UfileClientException, UfileServerException {
        try {
            return this.compareEtag(new FileInputStream(localFile), keyName, bucketName);
        }
        catch (FileNotFoundException e) {
            throw new UfileIOException((Throwable)e);
        }
    }

    public boolean compareEtag(InputStream localStream, String keyName, String bucketName) throws UfileClientException, UfileServerException {
        ObjectProfile res = (ObjectProfile)((Object)this.objectProfile(keyName, bucketName).execute());
        try {
            Etag eTag = Etag.etag((InputStream)localStream);
            return eTag.geteTag().equals(res.geteTag());
        }
        catch (IOException e) {
            throw new UfileIOException((Throwable)e);
        }
    }
}

