/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.ObjectContentBean;
import cn.ucloud.ufile.bean.ObjectListWithDirFormatBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import okhttp3.Response;

public class ObjectListWithDirFormatApi
extends UfileObjectApi<ObjectListWithDirFormatBean> {
    private String bucketName;
    private String prefix;
    private String marker;
    private Integer limit;
    private String delimiter;

    protected ObjectListWithDirFormatApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public ObjectListWithDirFormatApi atBucket(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public ObjectListWithDirFormatApi withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ObjectListWithDirFormatApi withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public ObjectListWithDirFormatApi dataLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public ObjectListWithDirFormatApi withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public ObjectListWithDirFormatApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        ArrayList<Parameter> query = new ArrayList<Parameter>();
        if (this.prefix != null) {
            query.add(new Parameter("prefix", (Object)this.prefix));
        }
        if (this.marker != null) {
            query.add(new Parameter("marker", (Object)this.marker));
        }
        if (this.limit != null) {
            query.add(new Parameter("max-keys", (Object)String.valueOf(this.limit)));
        }
        if (this.delimiter != null) {
            query.add(new Parameter("delimiter", (Object)this.delimiter));
        }
        this.contentType = "application/json; charset=utf-8";
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.GET, this.bucketName, "", this.contentType, "", date).setOptional(this.authOptionalData));
        GetRequestBuilder builder = new GetRequestBuilder();
        this.call = builder.baseUrl(this.generateFinalHost(this.bucketName, "") + "?listobjects&" + builder.generateUrlQuery(query)).setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date).addHeader("authorization", authorization).build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
        if (this.limit != null && this.limit < 1) {
            throw new UfileParamException("The required param 'limit' must be > 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectListWithDirFormatBean parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        ObjectListWithDirFormatBean objectListWithDirFormatBean;
        try {
            ObjectListWithDirFormatBean result = (ObjectListWithDirFormatBean)((Object)super.parseHttpResponse(response));
            if (result != null) {
                List<ObjectContentBean> contents;
                Set names;
                if (response.headers() != null && (names = response.headers().names()) != null) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    for (String name : names) {
                        headers.put(name, response.header(name, null));
                    }
                    result.setHeaders(headers);
                }
                if ((contents = result.getObjectContents()) != null && !contents.isEmpty()) {
                    for (ObjectContentBean content : contents) {
                        JsonObject jsonObj;
                        Set keys;
                        JsonElement json;
                        if (content == null || content.getJsonUserMeta() == null || (json = content.getJsonUserMeta()) == null || !(json instanceof JsonObject) || (keys = (jsonObj = (JsonObject)json).keySet()) == null) continue;
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        for (String name : keys) {
                            if (name == null || name.isEmpty()) continue;
                            metadata.put(name.toLowerCase(), jsonObj.get(name).getAsString());
                        }
                        content.setUserMeta(metadata);
                    }
                }
            }
            objectListWithDirFormatBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return objectListWithDirFormatBean;
    }
}

