/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.ObjectProfile;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.HeadRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import com.google.gson.JsonElement;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Response;

public class ObjectProfileApi
extends UfileObjectApi<ObjectProfile> {
    private String keyName;
    private String bucketName;

    protected ObjectProfileApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public ObjectProfileApi which(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public ObjectProfileApi atBucket(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public ObjectProfileApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        this.contentType = "application/json; charset=utf-8";
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.HEAD, this.bucketName, this.keyName, this.contentType, "", date).setOptional(this.authOptionalData));
        this.call = new HeadRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(this.generateFinalHost(this.bucketName, this.keyName)).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date).addHeader("authorization", authorization).build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
    }

    public ObjectProfile parseHttpResponse(Response response) throws UfileServerException {
        block5: {
            ObjectProfile objectProfile;
            try {
                Set names;
                ObjectProfile result = new ObjectProfile();
                int code = response.code();
                if (code != this.RESP_CODE_SUCCESS) break block5;
                result.setContentLength(Long.parseLong(response.header("Content-Length", "0")));
                result.setContentType(response.header("Content-Type", ""));
                result.seteTag(response.header("ETag", "").replace("\"", ""));
                result.setAcceptRanges(response.header("Accept-Ranges", ""));
                result.setCreateTime(response.header("X-Ufile-Create-Time", ""));
                result.setLastModified(response.header("Last-Modified", ""));
                result.setStorageType(response.header("X-Ufile-Storage-Class", ""));
                result.setRestoreTime(response.header("X-Ufile-Restore", ""));
                if (response.headers() != null && (names = response.headers().names()) != null) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    for (String name : names) {
                        headers.put(name, response.header(name, null));
                        if (name == null || !name.startsWith("X-Ufile-Meta-")) continue;
                        String key = name.substring(13).toLowerCase();
                        metadata.put(key, response.header(name, ""));
                    }
                    result.setHeaders(headers);
                    result.setMetadatas(metadata);
                }
                result.setBucket(this.bucketName);
                result.setKeyName(this.keyName);
                objectProfile = result;
            }
            catch (Throwable throwable) {
                FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
                throw throwable;
            }
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            return objectProfile;
        }
        throw new UfileServerException(this.parseErrorResponse(response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UfileErrorBean parseErrorResponse(Response response) {
        UfileErrorBean ufileErrorBean;
        try {
            UfileErrorBean errorBean = new UfileErrorBean();
            errorBean.setxSessionId(response.header("X-SessionId"));
            int code = response.code();
            errorBean.setResponseCode(code);
            switch (code) {
                case 404: {
                    errorBean.setErrMsg(String.format("The object '%s' is not existed in the bucket '%s'", this.keyName, this.bucketName));
                    break;
                }
                default: {
                    errorBean.setErrMsg(String.format("Http Error: Response-Code is %d", code));
                }
            }
            ufileErrorBean = errorBean;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return ufileErrorBean;
    }
}

