/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.base.BaseObjectResponseBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.PutJsonRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import com.google.gson.JsonElement;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Response;

public class ObjectRestoreApi
extends UfileObjectApi<BaseObjectResponseBean> {
    private String keyName;
    private String bucketName;

    protected ObjectRestoreApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public ObjectRestoreApi which(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public ObjectRestoreApi atBucket(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public ObjectRestoreApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        String keyName_tmp = this.keyName;
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.PUT, this.bucketName, keyName_tmp, this.contentType, "", date).setOptional(this.authOptionalData));
        this.call = new PutJsonRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(this.generateFinalHost(this.bucketName, keyName_tmp) + "?restore").addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date).addHeader("authorization", authorization).build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseObjectResponseBean parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        BaseObjectResponseBean baseObjectResponseBean;
        try {
            Set names;
            BaseObjectResponseBean result = (BaseObjectResponseBean)super.parseHttpResponse(response);
            if (response.headers() != null && (names = response.headers().names()) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : names) {
                    headers.put(name, response.header(name, null));
                }
                result.setHeaders(headers);
            }
            baseObjectResponseBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return baseObjectResponseBean;
    }
}

