/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.api.object.policy.PutPolicy;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.PutObjectResultBean;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.request.PutStreamRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Response;

public class PutStreamApi
extends UfileObjectApi<PutObjectResultBean> {
    protected String keyName;
    protected InputStream inputStream;
    protected String mimeType;
    protected MediaType mediaType;
    protected String bucketName;
    private boolean isVerifyMd5 = true;
    private ProgressConfig progressConfig = ProgressConfig.callbackDefault();
    private long contentLength = 0L;
    private String contentMD5;
    private int bufferSize = 524288;
    private PutPolicy putPolicy;
    protected Map<String, String> metadatas;
    protected String storageType;
    protected String iopCmd;
    private OnProgressListener onProgressListener;

    protected PutStreamApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public PutStreamApi nameAs(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public PutStreamApi from(InputStream inputStream, long contentLength, String mimeType) {
        this.inputStream = inputStream;
        this.contentLength = contentLength;
        this.mimeType = mimeType;
        this.mediaType = MediaType.parse((String)mimeType);
        return this;
    }

    public PutStreamApi toBucket(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public PutStreamApi withIopCmd(String iopCmd) {
        this.iopCmd = iopCmd;
        return this;
    }

    public PutStreamApi withVerifyMd5(boolean isVerifyMd5, String contentMD5) {
        this.isVerifyMd5 = isVerifyMd5;
        this.contentMD5 = contentMD5;
        return this;
    }

    public PutStreamApi withProgressConfig(ProgressConfig config) {
        this.progressConfig = config == null ? this.progressConfig : config;
        return this;
    }

    public PutStreamApi setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public PutStreamApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    public PutStreamApi withPutPolicy(PutPolicy putPolicy) {
        this.putPolicy = putPolicy;
        return this;
    }

    public PutStreamApi withMetaDatas(Map<String, String> datas) {
        if (datas == null) {
            this.metadatas = null;
            return this;
        }
        this.metadatas = new HashMap<String, String>(datas);
        return this;
    }

    public PutStreamApi addMetaData(Parameter<String> data) {
        if (data == null) {
            return this;
        }
        if (this.metadatas == null) {
            this.metadatas = new HashMap<String, String>();
        }
        this.metadatas.put(data.key, (String)data.value);
        return this;
    }

    public PutStreamApi withStorageType(String storageType) {
        this.storageType = storageType;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        Set<String> keys;
        this.parameterValidat();
        String contentType = this.mediaType.toString();
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String url = this.generateFinalHost(this.bucketName, this.keyName);
        if (this.iopCmd != null && !this.iopCmd.isEmpty()) {
            url = String.format("%s?%s", url, this.iopCmd);
        }
        PutStreamRequestBuilder builder = (PutStreamRequestBuilder)new PutStreamRequestBuilder(this.onProgressListener).setBufferSize((long)this.bufferSize).setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(url).addHeader("Content-Type", contentType).addHeader("Accpet", "*/*").addHeader("Date", date).mediaType(this.mediaType);
        builder.addHeader("Content-Length", String.valueOf(this.contentLength));
        if (this.storageType != null) {
            builder.addHeader("X-Ufile-Storage-Class", this.storageType);
        }
        if (this.metadatas != null && !this.metadatas.isEmpty() && (keys = this.metadatas.keySet()) != null) {
            for (String key : keys) {
                if (key == null || key.isEmpty()) continue;
                String value = this.metadatas.get(key);
                builder.addHeader("X-Ufile-Meta-" + key, value == null ? "" : value);
            }
        }
        if (this.contentMD5 == null) {
            this.contentMD5 = "";
        }
        if (this.isVerifyMd5) {
            builder.addHeader("Content-MD5", this.contentMD5);
        }
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.PUT, this.bucketName, this.keyName, contentType, this.contentMD5, date).setPutPolicy(this.putPolicy).setOptional(this.authOptionalData));
        builder.addHeader("authorization", authorization);
        builder.params((Object)this.inputStream);
        builder.setProgressConfig(this.progressConfig);
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.inputStream == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'inputStream' can not be null");
        }
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.mimeType == null || this.mimeType.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'mimeType' can not be null or empty");
        }
        if (this.mediaType == null) {
            throw new UfileParamException("The required param 'mimeType' is invalid");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
    }

    public PutStreamApi setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public void executeAsync(BaseHttpCallback<PutObjectResultBean, UfileErrorBean> callback) {
        this.onProgressListener = callback;
        super.executeAsync(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PutObjectResultBean parseHttpResponse(Response response) {
        PutObjectResultBean putObjectResultBean;
        try {
            Set names;
            PutObjectResultBean result = new PutObjectResultBean();
            String eTag = response.header("ETag", null);
            eTag = eTag == null ? null : eTag.replace("\"", "");
            result.seteTag(eTag);
            if (this.putPolicy != null) {
                result.setCallbackRet(this.readResponseBody(response));
            }
            if (response.headers() != null && (names = response.headers().names()) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : names) {
                    headers.put(name, response.header(name, null));
                }
                result.setHeaders(headers);
            }
            putObjectResultBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return putObjectResultBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UfileErrorBean parseErrorResponse(Response response) throws UfileClientException {
        UfileErrorBean errorBean;
        block5: {
            UfileErrorBean ufileErrorBean;
            try {
                errorBean = null;
                if (this.putPolicy == null) break block5;
                String content = this.readResponseBody(response);
                try {
                    errorBean = (UfileErrorBean)new Gson().fromJson(content == null || content.length() == 0 ? "{}" : content, UfileErrorBean.class);
                }
                catch (Exception e) {
                    errorBean = new UfileErrorBean();
                }
                errorBean.setResponseCode(response.code());
                errorBean.setxSessionId(response.header("X-SessionId"));
                errorBean.setCallbackRet(content);
                ufileErrorBean = errorBean;
            }
            catch (Throwable throwable) {
                FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
                throw throwable;
            }
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            return ufileErrorBean;
        }
        UfileErrorBean ufileErrorBean = errorBean = super.parseErrorResponse(response);
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return ufileErrorBean;
    }
}

