/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.base.BaseObjectResponseBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.PutJsonRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Response;

public class RenameObjectApi
extends UfileObjectApi<BaseObjectResponseBean> {
    protected String bucketName;
    protected String keyName;
    protected String newKeyName;
    protected boolean isForce;

    protected RenameObjectApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public RenameObjectApi which(String bucketName, String keyName) {
        this.bucketName = bucketName;
        this.keyName = keyName;
        return this;
    }

    public RenameObjectApi isRenamedTo(String newKeyName) {
        this.newKeyName = newKeyName;
        return this;
    }

    public RenameObjectApi isForcedToCover(boolean isForce) {
        this.isForce = isForce;
        return this;
    }

    public RenameObjectApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        this.contentType = "application/json; charset=utf-8";
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        PutJsonRequestBuilder builder = (PutJsonRequestBuilder)new PutJsonRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("newFileName", (Object)this.newKeyName));
        params.add(new Parameter("force", (Object)String.valueOf(this.isForce)));
        builder.baseUrl(builder.generateGetUrl(this.generateFinalHost(this.bucketName, this.keyName), params)).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date);
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.PUT, this.bucketName, this.keyName, this.contentType, "", date).setOptional(this.authOptionalData));
        builder.addHeader("authorization", authorization);
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'srcBucketName' can not be null or empty");
        }
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'srcKeyName' can not be null or empty");
        }
        if (this.newKeyName == null || this.newKeyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'newKeyName' can not be null or empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseObjectResponseBean parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        BaseObjectResponseBean baseObjectResponseBean;
        try {
            Set names;
            BaseObjectResponseBean result = (BaseObjectResponseBean)super.parseHttpResponse(response);
            if (response.headers() != null && (names = response.headers().names()) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : names) {
                    headers.put(name, response.header(name, null));
                }
                result.setHeaders(headers);
            }
            baseObjectResponseBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return baseObjectResponseBean;
    }
}

