/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.base.BaseObjectResponseBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileIOException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.PostJsonRequestBuilder;
import cn.ucloud.ufile.util.Etag;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Response;

public class UploadStreamHitApi
extends UfileObjectApi<BaseObjectResponseBean> {
    protected String keyName;
    protected InputStream inputStream;
    protected String bucketName;
    private ByteArrayOutputStream cacheOutputStream;

    protected UploadStreamHitApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public UploadStreamHitApi nameAs(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public UploadStreamHitApi from(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public UploadStreamHitApi toBucket(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public UploadStreamHitApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.POST, this.bucketName, this.keyName, this.contentType, "", date).setOptional(this.authOptionalData));
        PostJsonRequestBuilder builder = new PostJsonRequestBuilder();
        String url = this.generateFinalHost(this.bucketName, "uploadhit");
        ArrayList<Parameter> query = new ArrayList<Parameter>();
        this.backupStream();
        try {
            Etag etag = Etag.etag((InputStream)new ByteArrayInputStream(this.cacheOutputStream.toByteArray()));
            query.add(new Parameter("Hash", (Object)(etag == null ? null : etag.geteTag())));
        }
        catch (IOException e) {
            throw new UfileIOException("Calculate ETag failed!", (Throwable)e);
        }
        query.add(new Parameter("FileName", (Object)this.keyName));
        query.add(new Parameter("FileSize", (Object)String.valueOf(new ByteArrayInputStream(this.cacheOutputStream.toByteArray()).available())));
        this.call = builder.baseUrl(builder.generateGetUrl(url, query)).setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date).addHeader("authorization", authorization).build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.inputStream == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'inputStream' can not be null");
        }
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupStream() {
        this.cacheOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[65536];
        int len = 0;
        try {
            while ((len = this.inputStream.read(buff)) > 0) {
                this.cacheOutputStream.write(buff, 0, len);
            }
            this.cacheOutputStream.flush();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close((AutoCloseable[])new AutoCloseable[]{this.inputStream});
                throw throwable;
            }
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{this.inputStream});
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{this.inputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseObjectResponseBean parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        BaseObjectResponseBean baseObjectResponseBean;
        try {
            Set names;
            BaseObjectResponseBean result = (BaseObjectResponseBean)super.parseHttpResponse(response);
            if (response.headers() != null && (names = response.headers().names()) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : names) {
                    headers.put(name, response.header(name, null));
                }
                result.setHeaders(headers);
            }
            baseObjectResponseBean = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return baseObjectResponseBean;
    }
}

