/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object.multi;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.api.object.multi.MultiUploadInfo;
import cn.ucloud.ufile.api.object.multi.MultiUploadPartState;
import cn.ucloud.ufile.api.object.policy.PutPolicy;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.bean.MultiUploadResponse;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.PostStringRequestBuilder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Response;

public class FinishMultiUploadApi
extends UfileObjectApi<MultiUploadResponse> {
    private MultiUploadInfo info;
    private List<MultiUploadPartState> partStates;
    protected String newKeyName;
    private PutPolicy putPolicy;
    protected Map<String, String> metadatas;
    protected String metadataDirective;
    private Comparator<MultiUploadPartState> partStateComparator = new Comparator<MultiUploadPartState>(){

        @Override
        public int compare(MultiUploadPartState o1, MultiUploadPartState o2) {
            return o1.getPartIndex() > o2.getPartIndex() ? 1 : (o1.getPartIndex() == o2.getPartIndex() ? 0 : 1);
        }
    };

    public FinishMultiUploadApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public FinishMultiUploadApi which(MultiUploadInfo info, List<MultiUploadPartState> partStates) {
        this.info = info;
        this.partStates = partStates;
        return this;
    }

    public FinishMultiUploadApi renameAs(String newKeyName) {
        this.newKeyName = newKeyName;
        return this;
    }

    public FinishMultiUploadApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    public FinishMultiUploadApi withPutPolicy(PutPolicy putPolicy) {
        this.putPolicy = putPolicy;
        return this;
    }

    public FinishMultiUploadApi withMetaDatas(Map<String, String> datas) {
        if (datas == null) {
            this.metadatas = null;
            return this;
        }
        this.metadatas = new HashMap<String, String>(datas);
        return this;
    }

    public FinishMultiUploadApi addMetaData(Parameter<String> data) {
        if (data == null) {
            return this;
        }
        if (this.metadatas == null) {
            this.metadatas = new HashMap<String, String>();
        }
        this.metadatas.put(data.key, (String)data.value);
        return this;
    }

    public FinishMultiUploadApi withMetadataDirective(String metadataDirective) {
        this.metadataDirective = metadataDirective;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        Set<String> keys;
        this.parameterValidat();
        PostStringRequestBuilder builder = new PostStringRequestBuilder();
        ArrayList<Parameter> query = new ArrayList<Parameter>();
        query.add(new Parameter("uploadId", (Object)this.info.getUploadId()));
        query.add(new Parameter("newKey", (Object)(this.newKeyName == null ? "" : this.newKeyName)));
        if (this.partStates == null) {
            this.partStates = new ArrayList<MultiUploadPartState>();
        }
        Collections.sort(this.partStates, this.partStateComparator);
        StringBuffer bodyBuffer = new StringBuffer();
        int len = this.partStates.size();
        for (int i = 0; i < len; ++i) {
            MultiUploadPartState part = this.partStates.get(i);
            bodyBuffer.append(part.geteTag() + (i < len - 1 ? "," : ""));
        }
        this.contentType = MediaType.parse((String)this.info.getMimeType()).toString();
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.POST, this.info.getBucket(), this.info.getKeyName(), this.contentType, "", date).setPutPolicy(this.putPolicy).setOptional(this.authOptionalData));
        builder.baseUrl(builder.generateGetUrl(this.generateFinalHost(this.info.getBucket(), this.info.getKeyName()), query)).addHeader("Content-Type", this.contentType).addHeader("Content-Length", String.valueOf(bodyBuffer.length())).addHeader("Accpet", "*/*").addHeader("Date", date).addHeader("authorization", authorization).params((Object)bodyBuffer.toString());
        if (this.metadataDirective != null) {
            builder.addHeader("X-Ufile-Metadata-Directive", this.metadataDirective);
        }
        if (this.metadatas != null && !this.metadatas.isEmpty() && (keys = this.metadatas.keySet()) != null) {
            for (String key : keys) {
                if (key == null || key.isEmpty()) continue;
                String value = this.metadatas.get(key);
                builder.addHeader("X-Ufile-Meta-" + key, value == null ? "" : value);
            }
        }
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.info == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'info' can not be null");
        }
        if (this.partStates == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'partStates' can not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiUploadResponse parseHttpResponse(Response response) throws UfileServerException, UfileClientException {
        MultiUploadResponse result;
        block3: {
            result = null;
            try {
                if (this.putPolicy != null) {
                    result = new MultiUploadResponse();
                    result.setCallbackRet(this.readResponseBody(response));
                    break block3;
                }
                result = (MultiUploadResponse)((Object)super.parseHttpResponse(response));
                String eTag = response.header("ETag");
                eTag = eTag == null ? null : eTag.replace("\"", "");
                result.seteTag(eTag);
            }
            catch (Throwable throwable) {
                FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
                throw throwable;
            }
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UfileErrorBean parseErrorResponse(Response response) throws UfileClientException {
        UfileErrorBean errorBean;
        block5: {
            UfileErrorBean ufileErrorBean;
            errorBean = null;
            try {
                if (this.putPolicy == null) break block5;
                String content = this.readResponseBody(response);
                try {
                    errorBean = (UfileErrorBean)new Gson().fromJson(content == null || content.length() == 0 ? "{}" : content, UfileErrorBean.class);
                }
                catch (Exception e) {
                    errorBean = new UfileErrorBean();
                }
                errorBean.setResponseCode(response.code());
                errorBean.setxSessionId(response.header("X-SessionId"));
                errorBean.setCallbackRet(content);
                ufileErrorBean = errorBean;
            }
            catch (Throwable throwable) {
                FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
                throw throwable;
            }
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            return ufileErrorBean;
        }
        errorBean = super.parseErrorResponse(response);
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return errorBean;
    }
}

