/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object.multi;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.api.object.multi.MultiUploadInfo;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.PostJsonRequestBuilder;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Response;

public class InitMultiUploadApi
extends UfileObjectApi<MultiUploadInfo> {
    protected String keyName;
    protected String mimeType;
    protected MediaType mediaType;
    protected String bucketName;
    protected Map<String, String> metadatas;
    protected String storageType;

    public InitMultiUploadApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public InitMultiUploadApi nameAs(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public InitMultiUploadApi withMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.mediaType = MediaType.parse((String)mimeType);
        return this;
    }

    public InitMultiUploadApi toBucket(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public InitMultiUploadApi withMetaDatas(Map<String, String> datas) {
        if (datas == null) {
            this.metadatas = null;
            return this;
        }
        this.metadatas = new HashMap<String, String>(datas);
        return this;
    }

    public InitMultiUploadApi addMetaData(Parameter<String> data) {
        if (data == null) {
            return this;
        }
        if (this.metadatas == null) {
            this.metadatas = new HashMap<String, String>();
        }
        this.metadatas.put(data.key, (String)data.value);
        return this;
    }

    public InitMultiUploadApi withStorageType(String storageType) {
        this.storageType = storageType;
        return this;
    }

    public InitMultiUploadApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        Set<String> keys;
        this.parameterValidat();
        this.contentType = this.mediaType.toString();
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.POST, this.bucketName, this.keyName, this.contentType, "", date).setOptional(this.authOptionalData));
        PostJsonRequestBuilder builder = (PostJsonRequestBuilder)new PostJsonRequestBuilder().baseUrl(this.generateFinalHost(this.bucketName, this.keyName) + "?uploads").addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Date", date).addHeader("authorization", authorization);
        if (this.storageType != null) {
            builder.addHeader("X-Ufile-Storage-Class", this.storageType);
        }
        if (this.metadatas != null && !this.metadatas.isEmpty() && (keys = this.metadatas.keySet()) != null) {
            for (String key : keys) {
                if (key == null || key.isEmpty()) continue;
                String value = this.metadatas.get(key);
                builder.addHeader("X-Ufile-Meta-" + key, value == null ? "" : value);
            }
        }
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.keyName == null || this.keyName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'keyName' can not be null or empty");
        }
        if (this.mimeType == null || this.mimeType.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'mimeType' can not be null or empty");
        }
        if (this.mediaType == null) {
            throw new UfileParamException("The required param 'mimeType' is invalid");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'bucketName' can not be null or empty");
        }
    }

    public MultiUploadInfo parseHttpResponse(Response response) throws UfileServerException, UfileClientException {
        MultiUploadInfo state = (MultiUploadInfo)super.parseHttpResponse(response);
        state.setMimeType(this.mimeType);
        return state;
    }
}

