/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object.multi;

import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.api.object.UfileObjectApi;
import cn.ucloud.ufile.api.object.multi.MultiUploadInfo;
import cn.ucloud.ufile.api.object.multi.MultiUploadPartState;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.request.PutStreamRequestBuilder;
import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.HexFormatter;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.Parameter;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import okhttp3.MediaType;
import okhttp3.Response;

public class MultiUploadPartApi
extends UfileObjectApi<MultiUploadPartState> {
    private MultiUploadInfo info;
    private byte[] buffer;
    private int offset;
    private int length;
    private int partIndex;
    private boolean isVerifyMd5 = true;
    private int bufferSize = 524288;
    private ProgressConfig progressConfig = ProgressConfig.callbackDefault();
    private OnProgressListener onProgressListener;

    public MultiUploadPartApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(authorizer, objectConfig, httpClient);
    }

    public MultiUploadPartApi which(MultiUploadInfo info) {
        this.info = info;
        return this;
    }

    public MultiUploadPartApi from(byte[] buffer, int partIndex) {
        return this.from(buffer, 0, buffer == null ? 0 : buffer.length, partIndex);
    }

    public MultiUploadPartApi from(byte[] buffer, int offset, int length, int partIndex) {
        this.buffer = buffer;
        this.partIndex = partIndex;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public MultiUploadPartApi withVerifyMd5(boolean isVerifyMd5) {
        this.isVerifyMd5 = isVerifyMd5;
        return this;
    }

    public MultiUploadPartApi setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public MultiUploadPartApi withProgressConfig(ProgressConfig config) {
        this.progressConfig = config == null ? this.progressConfig : config;
        return this;
    }

    public MultiUploadPartApi withAuthOptionalData(JsonElement authOptionalData) {
        this.authOptionalData = authOptionalData;
        return this;
    }

    protected void prepareData() throws UfileClientException {
        this.parameterValidat();
        ArrayList<Parameter> query = new ArrayList<Parameter>();
        query.add(new Parameter("uploadId", (Object)this.info.getUploadId()));
        query.add(new Parameter("partNumber", (Object)String.valueOf(this.partIndex)));
        this.contentType = MediaType.parse((String)this.info.getMimeType()).toString();
        String contentMD5 = "";
        String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
        PutStreamRequestBuilder builder = new PutStreamRequestBuilder(this.onProgressListener).setBufferSize((long)this.bufferSize);
        builder.baseUrl(builder.generateGetUrl(this.generateFinalHost(this.info.getBucket(), this.info.getKeyName()), query)).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").addHeader("Content-Length", String.valueOf(this.length)).addHeader("Date", date).mediaType(MediaType.parse((String)this.info.getMimeType()));
        if (this.isVerifyMd5) {
            try {
                contentMD5 = HexFormatter.formatByteArray2HexString((byte[])Encoder.md5((byte[])this.buffer), (boolean)false);
                builder.addHeader("Content-MD5", contentMD5);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        String authorization = this.authorizer.authorization((ObjectOptAuthParam)new ObjectOptAuthParam(HttpMethod.PUT, this.info.getBucket(), this.info.getKeyName(), this.contentType, contentMD5, date).setOptional(this.authOptionalData));
        builder.addHeader("authorization", authorization);
        builder.params((Object)new ByteArrayInputStream(this.buffer, this.offset, this.length));
        builder.setProgressConfig(this.progressConfig);
        this.call = builder.build(this.httpClient.getOkHttpClient());
    }

    protected void parameterValidat() throws UfileParamException {
        if (this.info == null) {
            throw new UfileRequiredParamNotFoundException("The required param 'info' can not be null");
        }
        if (this.buffer == null || this.buffer.length == 0) {
            throw new UfileRequiredParamNotFoundException("The required param 'buffer' can not be null or empty");
        }
        int len = this.buffer.length;
        if (this.offset < 0 || this.offset > len - 1) {
            throw new UfileParamException(String.format("The offset you set %d, is out of data.length range[0,%d)", this.offset, len));
        }
        if (this.offset + this.length <= 0) {
            throw new UfileParamException(String.format("The offset + length you set (%d + %d), is < 1", this.offset, this.length));
        }
        if (this.offset + this.length > len) {
            throw new UfileParamException(String.format("The offset + length you set (%d + %d), is > data.length %d", this.offset, this.length, len));
        }
        if (this.partIndex < 0) {
            throw new UfileParamException("The required param 'partIndex' must be >= 0");
        }
    }

    public MultiUploadPartApi setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public void executeAsync(BaseHttpCallback callback) {
        this.onProgressListener = callback;
        super.executeAsync(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiUploadPartState parseHttpResponse(Response response) throws UfileServerException, UfileClientException {
        MultiUploadPartState multiUploadPartState;
        try {
            MultiUploadPartState result = new MultiUploadPartState();
            String eTag = response.header("ETag", null);
            eTag = eTag == null ? null : eTag.replace("\"", "");
            result.seteTag(eTag);
            if (result.getPartIndex() == -1) {
                result.setPartIndex(this.partIndex);
            }
            multiUploadPartState = result;
        }
        catch (Throwable throwable) {
            FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
            throw throwable;
        }
        FileUtil.close((AutoCloseable[])new AutoCloseable[]{response.body()});
        return multiUploadPartState;
    }
}

