/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.auth;

import cn.ucloud.ufile.auth.BucketLocalAuthorization;
import cn.ucloud.ufile.auth.UfileAuthorizationException;
import cn.ucloud.ufile.auth.sign.Signer;
import cn.ucloud.ufile.auth.sign.UfileSignatureException;
import cn.ucloud.ufile.util.Parameter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class UfileBucketLocalAuthorization
extends BucketLocalAuthorization {
    private Comparator<Parameter> keyComparator = new Comparator<Parameter>(){

        @Override
        public int compare(Parameter o1, Parameter o2) {
            return o1.key.compareTo(o2.key);
        }
    };

    public UfileBucketLocalAuthorization(String publicKey, String privateKey) {
        super(publicKey, privateKey);
    }

    public UfileBucketLocalAuthorization(String publicKey, String privateKey, Signer signer) {
        super(publicKey, privateKey, signer);
    }

    public String authorizeBucketUrl(List<Parameter<String>> urlQuery) throws UfileAuthorizationException, UfileSignatureException {
        if (urlQuery == null) {
            throw new UfileAuthorizationException("Param 'urlQuery' can not be null!");
        }
        Collections.sort(urlQuery, this.keyComparator);
        StringBuffer signData = new StringBuffer();
        for (Parameter<String> param : urlQuery) {
            signData.append(param.key + (String)param.value);
        }
        signData.append(this.privateKey);
        return this.signer.signatureBucket(signData.toString());
    }
}

