/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.auth;

import cn.ucloud.ufile.auth.ObjectDownloadAuthParam;
import cn.ucloud.ufile.auth.ObjectLocalAuthorization;
import cn.ucloud.ufile.auth.ObjectOptAuthParam;
import cn.ucloud.ufile.auth.UfileAuthorizationException;
import cn.ucloud.ufile.auth.sign.Signer;
import cn.ucloud.ufile.auth.sign.UfileSignatureException;
import cn.ucloud.ufile.util.HttpMethod;
import cn.ucloud.ufile.util.JLog;

public final class UfileObjectLocalAuthorization
extends ObjectLocalAuthorization {
    public UfileObjectLocalAuthorization(String publicKey, String privateKey) {
        super(publicKey, privateKey);
    }

    public UfileObjectLocalAuthorization(String publicKey, String privateKey, Signer signer) {
        super(publicKey, privateKey, signer);
    }

    public String authorization(ObjectOptAuthParam param) throws UfileAuthorizationException, UfileSignatureException {
        if (param == null) {
            throw new UfileAuthorizationException("Param can not be null!");
        }
        HttpMethod method = param.getMethod();
        String bucket = param.getBucket();
        String keyName = param.getKeyName();
        String contentType = param.getContentType();
        String contentMD5 = param.getContentMD5();
        String date = param.getDate();
        if (method == null) {
            throw new UfileAuthorizationException("Param 'method' can not be null!");
        }
        if (param.getBucket() == null || param.getBucket().length() == 0) {
            throw new UfileAuthorizationException("Param 'bucket' can not be blank!");
        }
        keyName = keyName == null ? "" : keyName;
        contentType = contentType == null ? "" : contentType;
        contentMD5 = contentMD5 == null ? "" : contentMD5;
        date = date == null ? "" : date;
        StringBuffer signData = new StringBuffer();
        signData.append(method.getName() + "\n");
        signData.append(contentMD5 + "\n");
        signData.append(contentType + "\n");
        signData.append(date + "\n");
        signData.append("/" + bucket);
        signData.append("/" + keyName);
        if (param.getPutPolicy() != null && param.getPutPolicy().getPolicy() != null) {
            signData.append(param.getPutPolicy().getPolicy());
        }
        JLog.D((String)"TEST", (String)("[signData]:" + signData.toString()));
        String signature = this.signer.signature(this.privateKey, signData.toString());
        return "UCloud " + this.publicKey + ":" + signature + (param.getPutPolicy() == null || param.getPutPolicy().getPolicy() == null ? "" : ":" + param.getPutPolicy().getPolicy());
    }

    public String authorizePrivateUrl(ObjectDownloadAuthParam param) throws UfileAuthorizationException, UfileSignatureException {
        if (param == null) {
            throw new UfileAuthorizationException("Param can not be null!");
        }
        HttpMethod method = param.getMethod();
        String bucket = param.getBucket();
        String keyName = param.getKeyName();
        long expires = param.getExpires();
        if (method == null) {
            throw new UfileAuthorizationException("Param 'method' can not be null!");
        }
        if (bucket == null || bucket.length() == 0) {
            throw new UfileAuthorizationException("Param 'bucket' can not be blank!");
        }
        if (keyName == null || keyName.length() == 0) {
            throw new UfileAuthorizationException("Param 'which' can not be blank!");
        }
        if (expires <= 0L) {
            throw new UfileAuthorizationException("Param 'expires' must be > 0!");
        }
        String contentMD5 = "";
        String contentType = "";
        StringBuffer signData = new StringBuffer();
        signData.append(method.getName() + "\n");
        signData.append(contentMD5 + "\n");
        signData.append(contentType + "\n");
        signData.append(expires + "\n");
        signData.append("/" + bucket);
        signData.append("/" + keyName);
        JLog.D((String)"TEST", (String)("[signData]:" + signData.toString()));
        return this.signer.signature(this.privateKey, signData.toString());
    }
}

