/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.PathUtil;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class WebDavFileStorage
implements FileStorage {
    private String server;
    private String user;
    private String password;
    private String platform;
    private String domain;
    private String basePath;
    private String storagePath;
    private Sardine client;

    public Sardine getClient() {
        if (this.client == null) {
            this.client = SardineFactory.begin((String)this.user, (String)this.password);
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    public String getUrl(String path) {
        return PathUtil.join(this.server, this.storagePath + path);
    }

    public void createDirectory(Sardine client, String path) throws IOException {
        if (!client.exists(path)) {
            this.createDirectory(client, PathUtil.join(PathUtil.getParent(path), "/"));
            client.createDirectory(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String path = this.basePath + fileInfo.getPath();
        String newFileKey = path + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        Sardine client = this.getClient();
        try (InputStream in = pre.getFileWrapper().getInputStream();){
            byte[] bytes = IoUtil.readBytes((InputStream)in);
            this.createDirectory(client, this.getUrl(path));
            client.put(this.getUrl(newFileKey), bytes);
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                String newThFileKey = path + fileInfo.getThFilename();
                fileInfo.setThUrl(this.domain + newThFileKey);
                client.put(this.getUrl(newThFileKey), thumbnailBytes);
            }
            boolean bl = true;
            return bl;
        }
        catch (IORuntimeException | IOException e) {
            try {
                client.delete(this.getUrl(newFileKey));
                throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        Sardine client = this.getClient();
        try {
            block8: {
                block7: {
                    if (fileInfo.getThFilename() != null) {
                        try {
                            client.delete(this.getUrl(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));
                        }
                        catch (SardineException e) {
                            if (e.getStatusCode() == 404) break block7;
                            throw e;
                        }
                    }
                }
                try {
                    client.delete(this.getUrl(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
                }
                catch (SardineException e) {
                    if (e.getStatusCode() == 404) break block8;
                    throw e;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getClient().exists(this.getUrl(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (InputStream in = this.getClient().get(this.getUrl(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (InputStream in = this.getClient().get(this.getUrl(fileInfo.getBasePath() + fileInfo.getPath()) + fileInfo.getThFilename());){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public String getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public void setClient(Sardine client) {
        this.client = client;
    }
}

