/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public abstract class RequestBase {
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": ");
        try {
            Endpoint endpoint = (Endpoint)this.getClass().getDeclaredField("_ENDPOINT").get(null);
            sb.append(endpoint.method(this)).append(" ").append(endpoint.requestUrl(this));
            Map<String, String> params = endpoint.queryParameters(this);
            String delim = "?";
            for (Map.Entry<String, String> param : params.entrySet()) {
                sb.append(delim);
                delim = "&";
                sb.append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this instanceof JsonpSerializable) {
            sb.append(' ');
            JsonpUtils.toString((JsonpSerializable)((Object)this), sb);
        }
        return sb.toString();
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        protected AbstractBuilder() {
        }

        @Override
        protected abstract BuilderT self();
    }
}

