/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ScriptBase
implements JsonpSerializable {
    private final Map<String, JsonData> params;

    protected ScriptBase(AbstractBuilder<?> builder) {
        this.params = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).params);
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupScriptBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Map<String, JsonData> params;

        protected AbstractBuilder() {
        }

        public final BuilderT params(Map<String, JsonData> map) {
            this.params = AbstractBuilder._mapPutAll(this.params, map);
            return (BuilderT)this.self();
        }

        public final BuilderT params(String key, JsonData value) {
            this.params = AbstractBuilder._mapPut(this.params, key, value);
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

