/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoLine;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoLineAggregate
extends AggregateBase
implements AggregateVariant {
    private final String type;
    private final GeoLine geometry;
    public static final JsonpDeserializer<GeoLineAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoLineAggregate::setupGeoLineAggregateDeserializer);

    private GeoLineAggregate(Builder builder) {
        super(builder);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.geometry = ApiTypeHelper.requireNonNull(builder.geometry, this, "geometry");
    }

    public static GeoLineAggregate of(Function<Builder, ObjectBuilder<GeoLineAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.GeoLine;
    }

    public final String type() {
        return this.type;
    }

    public final GeoLine geometry() {
        return this.geometry;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("geometry");
        this.geometry.serialize(generator, mapper);
    }

    protected static void setupGeoLineAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::geometry, GeoLine._DESERIALIZER, "geometry");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoLineAggregate> {
        private String type;
        private GeoLine geometry;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder geometry(GeoLine value) {
            this.geometry = value;
            return this;
        }

        public final Builder geometry(Function<GeoLine.Builder, ObjectBuilder<GeoLine>> fn) {
            return this.geometry(fn.apply(new GeoLine.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoLineAggregate build() {
            this._checkSingleUse();
            return new GeoLineAggregate(this);
        }
    }
}

