/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MovingFunctionAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final String script;
    @Nullable
    private final Integer shift;
    @Nullable
    private final Integer window;
    public static final JsonpDeserializer<MovingFunctionAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MovingFunctionAggregation::setupMovingFunctionAggregationDeserializer);

    private MovingFunctionAggregation(Builder builder) {
        super(builder);
        this.script = builder.script;
        this.shift = builder.shift;
        this.window = builder.window;
    }

    public static MovingFunctionAggregation of(Function<Builder, ObjectBuilder<MovingFunctionAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MovingFn;
    }

    @Nullable
    public final String script() {
        return this.script;
    }

    @Nullable
    public final Integer shift() {
        return this.shift;
    }

    @Nullable
    public final Integer window() {
        return this.window;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.shift != null) {
            generator.writeKey("shift");
            generator.write(this.shift.intValue());
        }
        if (this.window != null) {
            generator.writeKey("window");
            generator.write(this.window.intValue());
        }
    }

    protected static void setupMovingFunctionAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::script, JsonpDeserializer.stringDeserializer(), "script");
        op.add(Builder::shift, JsonpDeserializer.integerDeserializer(), "shift");
        op.add(Builder::window, JsonpDeserializer.integerDeserializer(), "window");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MovingFunctionAggregation> {
        @Nullable
        private String script;
        @Nullable
        private Integer shift;
        @Nullable
        private Integer window;

        public final Builder script(@Nullable String value) {
            this.script = value;
            return this;
        }

        public final Builder shift(@Nullable Integer value) {
            this.shift = value;
            return this;
        }

        public final Builder window(@Nullable Integer value) {
            this.window = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MovingFunctionAggregation build() {
            this._checkSingleUse();
            return new MovingFunctionAggregation(this);
        }
    }
}

